<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include('../../../inc/includes.php');
//var_dump("zzz");
//die();
header('Content-Type: application/json; charset=UTF-8');

Session::checkLoginUser();

try {
    // message_ids peut venir en JSON (fetch) ou en form-urlencoded (jQuery)
    $message_ids = [];
    if ($_SERVER['CONTENT_TYPE'] ?? '' === 'application/json') {
        $raw = file_get_contents('php://input');
        $j = json_decode($raw, true);
        if (is_array($j) && isset($j['message_ids']) && is_array($j['message_ids'])) {
            $message_ids = $j['message_ids'];
        }
    }
    if (empty($message_ids) && isset($_POST['message_ids'])) {
        $message_ids = is_array($_POST['message_ids']) ? $_POST['message_ids'] : explode(',', (string)$_POST['message_ids']);
    }

    $message_ids = array_values(array_unique(array_map('intval', (array)$message_ids)));

    if (empty($message_ids)) {
        echo json_encode(['ok'=>true, 'data'=>[]]);
        exit;
    }

    $data = PluginDlteamsITILFollowup_Reaction::getAggregatesForMessages($message_ids, Session::getLoginUserID());
    echo json_encode(['ok'=>true, 'data'=>$data]);
} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}