<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

header('Content-Type: application/json; charset=UTF-8');

Session::checkLoginUser();

try {
    // Optionnel : CSRF si tu l’actives sur tes formulaires
    // Session::checkCSRF();

    $itilfollowups_id = (int)($_POST['itilfollowups_id'] ?? 0);
    $emoji_key        = (string)($_POST['emoji_key'] ?? '');

    if ($itilfollowups_id <= 0 || $emoji_key === '') {
        throw new RuntimeException(__('Paramètres invalides'));
    }

    $res = PluginDlteamsITILFollowup_Reaction::toggle($itilfollowups_id, $emoji_key, Session::getLoginUserID());

    echo json_encode([
        'ok'         => true,
        'hasReacted' => $res['hasReacted'],
        'newCount'   => $res['newCount']
    ]);
} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}