<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */
include("../../../inc/includes.php");
use Glpi\Event;

/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
if (!isset($_GET['id'])) {
   $_GET['id'] = "";
}

$concernedperson = new PluginDlteamsConcernedPerson();

if (isset($_POST['add'])) {
   $concernedperson->check(-1, CREATE, $_POST);
   $id = $concernedperson->add($_POST);
    if ($_SESSION['glpibackcreated']) {
        Html::redirect($concernedperson->getFormURLWithID($id));
    }
    Html::back();

} else if (isset($_POST['update'])) {
   $concernedperson->check($_POST['id'], UPDATE);
   $concernedperson->update($_POST);


   $record_item_request = [
       "FROM" => PluginDlteamsRecord_Item::getTable(),
       "WHERE" => [
           "itemtype" => PluginDlteamsConcernedPerson::class,
           "items_id" => $_POST['id']
       ]
   ];
   global $DB;
    $record_item_request_iterator = $DB->request($record_item_request);
   foreach ($record_item_request_iterator as $item){
       $r = new PluginDlteamsRecord();
       $r->getFromDB($item["records_id"]);
       $itemspersonnesdonnees = $DB->request(PluginDlteamsRecord_PersonalAndDataCategory::getRequest($r));
       $nb = 0;
       foreach ($itemspersonnesdonnees as $itemspersonnesdonnee){

           $concernedperson = new PluginDlteamsConcernedPerson();
           if($concernedperson->getFromDB($itemspersonnesdonnee["items_id"])){
               $nb += $concernedperson->fields["number"];
           }
       }

       $DB->update(PluginDlteamsRecord::getTable(),[
           "r_nbr_concernedpersons" => $nb
       ],
           ["id" => $item["records_id"]]);
   }



   Html::back();

} else if (isset($_POST['delete'])) {
   $concernedperson->check($_POST['id'], DELETE);
   $concernedperson->delete($_POST);
   $concernedperson->redirectToList();

} else if (isset($_POST['purge'])) {
   $concernedperson->check($_POST['id'], PURGE);
   $concernedperson->delete($_POST, true);
   $concernedperson->redirectToList();

}
else if (isset($_POST["restore"])) {
    $concernedperson->check($_POST["id"], DELETE);

    $concernedperson->restore($_POST);
    Event::log(
        $_POST["id"],
        "concernedperson",
        4,
        "dlteams",
        //TRANS: %s is the user login
        sprintf(__('%s restores an item'), $_SESSION["glpiname"])
    );
    $concernedperson->redirectToList();
}
else {
   $concernedperson->checkGlobal(READ);

   if (Session::getCurrentInterface() == 'central') {
//    Html::header(PluginDlteamsConcernedPerson::getTypeName(2), '', 'dlteams', 'plugindlteamsmenu', 'concernedperson');
//       Html::header(PluginDlteamsConcernedPerson::getTypeName(2), '', "datagovernance","datagovernanceconcernedperson", "concernedperson");

       $menus = ["datagovernance", "datagovernanceconcernedperson", "concernedperson"];
       PluginDlteamsConcernedPerson::displayFullPageForItem($_GET['id'], $menus, [
           'formoptions'  => "data-track-changes=true",
       ]);
   } else {
      Html::helpHeader(PluginDlteamsConcernedPerson::getTypeName(0));
   }

   $concernedperson->display(['id' => $_GET['id']]);

   if (Session::getCurrentInterface() == 'central') {
      Html::footer();
   } else {
      Html::helpFooter();
   }
}