<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

if (!isset($_GET['id'])) {
    $_GET['id'] = "";
}
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();

$datacatalog = new PluginDlteamsDataCatalog();

if (isset($_POST['add'])) {

    $datacatalog->check(-1, CREATE, $_POST);
    $data = $_POST;
    //$data["completename"] = addslashes($_POST["name"]);
    $data["completename"] = $_POST["name"];
    if (isset($_POST["plugin_dlteams_datacatalogs_id"]) && $_POST["plugin_dlteams_datacatalogs_id"]) {
        $datacatalog_parent = new PluginDlteamsDataCatalog();
        $datacatalog_parent->getFromDB($_POST["plugin_dlteams_datacatalogs_id"]);

        //$data["completename"] = $datacatalog_parent->fields["name"] . " > " . addslashes($_POST["name"]);
        $data["completename"] = $datacatalog_parent->fields["name"] . " > " . $_POST["name"];
    }


    unset($data["contact_itemtype"]);
    unset($data["contacts_id"]);

    $id = $datacatalog->add($data);

    Html::redirect($datacatalog->getFormURLWithID($id));

}
else if (isset($_POST['update'])) {
    $data = $_POST;
    $data["keyrequired"] = !!$data["keyrequired"];
/*    highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");*/
//    die();

    //$data["completename"] = addslashes($_POST["name"]);
    $data["completename"] = $_POST["name"];
    if (isset($_POST["plugin_dlteams_datacatalogs_id"]) && $_POST["plugin_dlteams_datacatalogs_id"]) {
        $datacatalog_parent = new PluginDlteamsDataCatalog();

        $datacatalog_parent->getFromDB($_POST["plugin_dlteams_datacatalogs_id"]);

        //$data["completename"] = $datacatalog_parent->fields["name"] . " > " . addslashes($_POST["name"]);
        $data["completename"] = $datacatalog_parent->fields["name"] . " > " . $_POST["name"];
    }
    $datacatalog->check($data['id'], UPDATE);


    unset($data["contact_itemtype"]);
    unset($data["contacts_id"]);

    $updateallchildren_keyrequired = false;
    if($datacatalog->getFromDB($data["id"]) && $datacatalog->fields["plugin_dlteams_datacatalogs_id"]){
        $dtp = new PluginDlteamsDataCatalog();
        $dtp->getFromDB($datacatalog->fields["plugin_dlteams_datacatalogs_id"]);

//        on cherche le root
        $rootfound = false;
        do{
//          check if parent is root
            if($dtp && $dtp->fields["plugin_dlteams_datacatalogs_id"] == 0){
                // il est root
                $data["keyrequired"] = $dtp->fields["keyrequired"];
                $rootfound = true;
            }
            else{
                // on charge les données du prochain parent pour la prochaine itération et verification
                $dtp->getFromDB($dtp->fields["plugin_dlteams_datacatalogs_id"]);
            }
        }
        while($rootfound == false);
    }
    else{
//         il est root
        $updateallchildren_keyrequired = true;
    }


//j'ai un catalogue root
//je le met comme sous catalogue
//Alors "Protection de l'accès à ce catalogue" prend la valeur du root
    if($data["id"] && $datacatalog->getFromDB($data["id"]) && $datacatalog->fields["plugin_dlteams_datacatalogs_id"] == 0 && $_POST["plugin_dlteams_datacatalogs_id"]){
        //        on cherche le root
        $dtp = new PluginDlteamsDataCatalog();
        $dtp->getFromDB($_POST["plugin_dlteams_datacatalogs_id"]);
        $rootfound = false;
        do{
//          check if parent is root
            if($dtp && $dtp->fields["plugin_dlteams_datacatalogs_id"] == 0){
                // il est root
                $data["keyrequired"] = $dtp->fields["keyrequired"];
                $rootfound = true;
            }
            else{
                // on charge les données du prochain parent pour la prochaine itération et verification
                $dtp->getFromDB($dtp->fields["plugin_dlteams_datacatalogs_id"]);
            }
        }
        while($rootfound == false);
    }


    if($data["id"] && $datacatalog->getFromDB($data["id"]) && $datacatalog->fields["plugin_dlteams_datacatalogs_id"] != 0 && $_POST["plugin_dlteams_datacatalogs_id"] == 0){
        // il n'était pas root, il est devenu root. on mets a jour donc tous ses enfants
        global $DB;
        $r = $DB->update(PluginDlteamsDataCatalog::getTable(), [
            "keyrequired" => $data["keyrequired"]
        ], ["plugin_dlteams_datacatalogs_id" => $data["id"]]);
    }
    $result = $datacatalog->update([
        ...$data,
    ]);

    if($result && $updateallchildren_keyrequired){
        global $DB;
        $r = $DB->update(PluginDlteamsDataCatalog::getTable(), [
            "keyrequired" => $data["keyrequired"]
        ], ["plugin_dlteams_datacatalogs_id" => $data["id"]]);


//        var_dump($r);
//        die();
        Session::addMessageAfterRedirect("Les catalogues enfants ont été mis a jours");
    }



    Html::back();
}
elseif (isset($_POST["update_as_child"])) {
    $datacatalog = new PluginDlteamsDataCatalog();
    $datacatalog->getFromDB($_POST["son_id"]);

    $data = ["plugin_dlteams_datacatalogs_id" => $_POST["id"]];

    $datacatalog_parent = new PluginDlteamsDataCatalog();
    $datacatalog_parent->getFromDB($_POST["id"]);

    $data["completename"] = $datacatalog_parent->fields["name"] . " > " . $datacatalog->fields["name"];
    $data["id"] = $_POST["son_id"];

    $datacatalog->check($data['id'], UPDATE);
    $data["update"] = true;

    $datacatalog->update([
        ...$data
    ]);

    Html::back();

}
elseif (isset($_POST["changeto_directory"])){
    $datacatalog = new PluginDlteamsDataCatalog();
    if($datacatalog->getFromDB($_POST["id"])){
        $datacatalog->update([
            "manage_accountkey" => true,
            "id" => $_POST["id"]
        ]);
    }

    Session::addMessageAfterRedirect("Opération éffectuée avec succès");
    Html::back();
}
elseif(isset($_POST["delete_directory"])){

    global $DB;
//    $catalog = new PluginDlteamsDataCatalog();
//    $catalog->getFromDB($_POST["id"]);
//        $iterator = PluginDlteamsDataCatalog::annuaireTiersRequest($catalog);
//        $linkidx = [];
//        foreach ($iterator as $d){
//            $linkidx[] = $d["linkid"];
//
//        }
//
//        if(count($linkidx)>0){
//            $DB->delete(PluginDlteamsDataCatalog_Item::getTable(), [
//                "id" => $linkidx
//            ]);
//        }
    $accountkey = new PluginDlteamsAccountKey();
    $catalog = new PluginDlteamsDataCatalog();
    $catalog->getFromDB($_POST["id"]);
    $iterator = PluginDlteamsAccountKey_Directory::showForItemgetRequest($catalog, true);
    $annuairetier_idx = array_column(iterator_to_array($iterator), "id");
//    var_dump($annuairetier_idx);
//    die();
    if (count($annuairetier_idx)>0)
    $result = $DB->update($accountkey->getTable(),[
        "plugin_dlteams_datacatalogs_id" => 0
    ],
    [
        "id" => $annuairetier_idx
    ]);

//    var_dump($result);
//    die();

    $datacatalog->update([
        "manage_accountkey" => false,
        "id" => $_POST["id"]
    ]);
//        if($r)
            Session::addMessageAfterRedirect("Les services d'annuaire utilisés pour les accès à ce catalogue ont été retirés");

        Html::back();
}
else if (isset($_POST['delete'])) {

    $datacatalog->check($_POST['id'], DELETE);
    $datacatalog->delete($_POST);
    $datacatalog->redirectToList();

}
else if (isset($_POST['restore'])) {
    $datacatalog->check($_POST['id'], UPDATE);
    $datacatalog->restore($_POST);
    $datacatalog->redirectToList();

}
else if (isset($_POST['purge'])) {
    $datacatalog->check($_POST['id'], PURGE);


//

    if (
        $datacatalog->isUsed()
        && empty($_POST["forcepurge"])
    ) {
        Html::header(
            $datacatalog->getTypeName(1),
            $_SERVER['PHP_SELF'],
            "admin",
            "datacatalog",
            str_replace('glpi_', '', $datacatalog->getTable())
        );

        $datacatalog->showDeleteConfirmForm($_SERVER['PHP_SELF']);
        Html::footer();
    } else {

        //    supprimer tous les comptes de l'annuaire
        $accountkey = new PluginDlteamsAccountKey();
        global $DB;
        $DB->update(
            $accountkey->getTable(),
            [
                "plugin_dlteams_datacatalogs_id" => 0
            ],
            [
                "plugin_dlteams_datacatalogs_id" => $_POST['id']
            ]
        );
        Session::addMessageAfterRedirect("Tous les comptes ont été supprimés de l'annuaire");

        $datacatalog->delete($_POST, 1);
        Event::log(
            $_POST["id"],
            "datacatalogs",
            4,
            "setup",
            //TRANS: %s is the user login
            sprintf(__('%s purges an item'), $_SESSION["glpiname"])
        );
        $datacatalog->redirectToList();
    }

//

}
elseif (isset($_POST["add_other_directory"])) {

    $datacatalog_item = new PluginDlteamsDataCatalog_Item();
    $datacatalog_item->add([
        "datacatalogs_id" => $_POST["datacatalogs_id"],
        "itemtype" => PluginDlteamsDataCatalog::class,
        "items_id" => $_POST["items_id"],
        "is_directory" => 1
    ]);


    Session::addMessageAfterRedirect("Ajouté avec succès");
    Html::back();
}
else {
    $datacatalog->checkGlobal(READ);

    if (Session::getCurrentInterface() == 'central') {
//        Html::header(PluginDlteamsDataCatalog::getTypeName(2), '', "dataaccess", PluginDlteamsDataCatalog::$menukey, "datacatalog");


        $menus = ["dataaccess", PluginDlteamsDataCatalog::$menukey, "datacatalog"];
        PluginDlteamsDataCatalog::displayFullPageForItem($_GET['id'], $menus, [
            'formoptions'  => "data-track-changes=true",
        ]);


    } else {
        Html::helpHeader(PluginDlteamsDataCatalog::getTypeName(0));
        $datacatalog->display(['id' => $_GET['id']]);
    }


    if (Session::getCurrentInterface() == 'central') {
        Html::footer();
    } else {
        Html::helpFooter();
    }

}
