<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */
include("../../../inc/includes.php");


/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
$saveitem = false;
if (isset($_POST["save_notification_data"]) && $_POST["save_notification_data"]) {

    $itemtype_str = $_POST["itemtype"];
    $itemtype = new $itemtype_str();
//    $deliverable = new PluginDlteamsDeliverable();
    $itemtype->getFromDB($_POST["items_id"]);


    if ($itemtype) {
        $itemtype->update([
            "text_approval" => $_POST["approbation_text"],
            "text_notification" => $_POST["notification_text"],
            "object_notification" => $_POST["object"],
            "object_approval" => $_POST["object_approbation"],
            "id" => $itemtype->fields["id"]
        ]);

        Session::addMessageAfterRedirect("Paramètres de notification enrégistrés");
    }

    Html::back();
}

if (!isset($_POST["itemtype"]) || !isset($_POST["items_id"]) || !$_POST["itemtype"] || !$_POST["items_id"]) {
    Session::addMessageAfterRedirect("Veuillez choisir un destinataire", false, ERROR);
    Html::back();
}

$itemtype1 = $_POST["itemtype1"];
$items_id1 = $_POST["items_id1"];

$receiver = new $itemtype1();
$receiver->getFromDB($items_id1);
$receiver_mails = [];
if ($receiver) {
    if ($itemtype1 == "Contact") {
        if (!empty($receiver->fields["email"])) {
            $receiver_mails[] = $receiver->fields["email"];
        }
    } elseif ($itemtype1 == "Group") {
        $group_users = Group_User::getGroupUsers($receiver->fields["id"]);
        foreach ($group_users as $user) {
            $mail = UserEmail::getDefaultForUser($user["id"]);
            if (NotificationMailing::isUserAddressValid($mail)) {
                $receiver_mails[] = $mail;
            }
        }
    } else { // User
        $mail = UserEmail::getDefaultForUser($receiver->fields["id"]);
        if (NotificationMailing::isUserAddressValid($mail)) {
            $receiver_mails[] = $mail;
        }
    }

    if (empty($receiver_mails)) {
        Session::addMessageAfterRedirect("Le destinataire ne possède pas d'adresse email valide.", false, WARNING);
        Html::back();
    }

    $approbation_token = sha1(Toolbox::getRandomString(30));
    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
    $approbation_text = "<br/><br/>Si vous n'arrivez pas à valider en cliquant sur le bouton, veuillez copier le lien ci-dessous et le coller dans votre navigateur : ";
    $approbation_text .= $server_url . "/marketplace/dlteams/front/approve.form.php?token=" . $approbation_token;
    $approbation_link = $server_url . "/marketplace/dlteams/front/approve.form.php?token=" . $approbation_token;
    $approbation_button = "<center><a style='padding: 5px; background-color: #0a6aa1; color: white; border-radius: 3px;' href='$approbation_link'>cliquer pour approuver</a></center>";
} else {
    Session::addMessageAfterRedirect("Destinataire non trouvé", false, WARNING);
    Html::back();
}


/*highlight_string("<?php\n\$data =\n" . var_export($receiver_mails, true) . ";\n?>");*/
//die();
if (isset($_POST["send_notification"])) {


    $itemtype_str = $_POST["itemtype"];
    $itemtype = new $itemtype_str();
//    $deliverable = new PluginDlteamsDeliverable();
    $itemtype->getFromDB($_POST["items_id"]);
    $itemtype->getFromDB($_POST["deliverable_id"]);

    if (!$itemtype->fields["object_notification"]
        || !$itemtype->fields["text_notification"]
        || strlen($itemtype->fields["object_notification"]) == 0
        || strlen($itemtype->fields["text_notification"]) == 0
    ) {
        Session::addMessageAfterRedirect("Veuillez enrégistrer l'objet et le texte de notification", false, ERROR);
        Html::back();
    }

    if ($itemtype) {
        var_dump($receiver_mails);
        foreach ($receiver_mails as $mail_addr) {
            $data = [
                "subject" => $itemtype->fields["object_notification"],
                "content_html" =>  html_entity_decode($itemtype->fields["text_notification"]),
                "to" => $mail_addr,
                "toname" => $mail_addr,
            ];

            var_dump($data);
            $mail = new PluginDlteamsNotificationMail();
            var_dump("zzz");
            if ($mail->sendNotification($data)) {
            var_dump("zzz");
                $saveitem = true;
                Session::addMessageAfterRedirect("Notification envoyée à $mail_addr");
            } else {
                Session::addMessageAfterRedirect("Notification non envoyée à $mail_addr", false, ERROR);
            }
        }
        die();
        
    } else
        Session::addMessageAfterRedirect("Une erreur s'est produite", false, ERROR);
}
elseif (isset($_POST["send_approval"])) {
//    $deliverable = new PluginDlteamsDeliverable();

    $itemtype_str = $_POST["itemtype"];
    $itemtype = new $itemtype_str();
//    $deliverable = new PluginDlteamsDeliverable();
    $itemtype->getFromDB($_POST["items_id"]);
    $itemtype->getFromDB($_POST["deliverable_id"]);

    if ($itemtype) {
        $approbation_content_html = html_entity_decode($itemtype->fields["text_approval"])."<br/>".$approbation_button . $approbation_text;
        foreach ($receiver_mails as $mail_addr) {
            $data = [
                "subject" => $deliverable->fields["object_approval"]??"",
                "content_html" => $approbation_content_html,
                "to" => $mail_addr,
                "toname" => $mail_addr,
            ];

            var_dump($data);
            $mail = new PluginDlteamsNotificationMail();
            if ($mail->sendNotification($data)) {
                $saveitem = true;
                Session::addMessageAfterRedirect("Notification envoyée à $mail_addr");
            } else {
                Session::addMessageAfterRedirect("Notification non envoyée à $mail_addr", false, ERROR);
            }
        }
    } else
        Session::addMessageAfterRedirect("Une erreur s'est produite", false, ERROR);
}
elseif (isset($_POST["send_notification_and_approval"])) {
//    $deliverable = new PluginDlteamsDeliverable();
    $itemtype_str = $_POST["itemtype"];
    $itemtype = new $itemtype_str();
//    $deliverable = new PluginDlteamsDeliverable();
    $itemtype->getFromDB($_POST["items_id"]);
    $itemtype->getFromDB($_POST["deliverable_id"]);

    if ($itemtype) {
//        send notification
        foreach ($receiver_mails as $mail_addr) {
            $data = [
                "subject" => $itemtype->fields["object_notification"]??"",
                "content_html" => html_entity_decode($itemtype->fields["text_notification"]),
                "to" => $mail_addr,
                "toname" => $mail_addr,
            ];

            var_dump($data);
            $mail = new PluginDlteamsNotificationMail();
            if ($mail->sendNotification($data)) {
                Session::addMessageAfterRedirect("Notification envoyée à $mail_addr");
            } else {
                Session::addMessageAfterRedirect("Notification non envoyée à $mail_addr", false, ERROR);
            }
        }

//        send approval

        $approbation_content_html = html_entity_decode($itemtype->fields["text_approval"])."<br/>".$approbation_button . $approbation_text;
        foreach ($receiver_mails as $mail_addr) {
            $data = [
                "subject" => $itemtype->fields["object_approval"],
                "content_html" => $approbation_content_html,
                "to" => $mail_addr,
                "toname" => $mail_addr,
            ];

            var_dump($data);
            $mail = new PluginDlteamsNotificationMail();
            if ($mail->sendNotification($data)) {
                $saveitem = true;
                Session::addMessageAfterRedirect("Approbation envoyée à $mail_addr");
            } else {
                Session::addMessageAfterRedirect("Approbation non envoyée à $mail_addr", false, ERROR);
            }
        }
    } else
        Session::addMessageAfterRedirect("Une erreur s'est produite", false, ERROR);
}

if ($saveitem) {

    $itemtype->update([
        "text_approval" => $_POST["approbation_text"],
        "text_notification" => $_POST["notification_text"],
        "object_notification" => $_POST["object"],
        "object_approval" => $_POST["object_approbation"],
        "id" => $itemtype->fields["id"]
    ]);



    $deliverable_item = new PluginDlteamsDeliverable_Item();
    $data = [
        "deliverables_id" => 0,
        "itemtype1" => $_POST["itemtype1"],
        "itemtype" => $_POST["itemtype"],
        "items_id1" => $_POST["items_id1"],
        "items_id" => $_POST["items_id"],
    ];

    $test = $deliverable_item->add([
        ...$data,
        "comment" => $_POST["notification_text"],
        "approval_token" => $approbation_token,
        "email" => $receiver_mails,
        "object_notification" => $_POST["object"],
        "object_approval" => $_POST["object_approbation"],
        "text_approval" => $_POST["approbation_text"],
    ]);


    $itemtype1_item_str = "PluginDlteams" . $itemtype1 . "_Item";
    $itemtype1_item = new $itemtype1_item_str();
    if ($itemtype1 == Contact::class)
        $id_column_name = "contacts_id";
    else
        $id_column_name = "users_id";

    $data2 = [
        $id_column_name => $items_id1,
        "itemtype" => PluginDlteamsDeliverable::class,
        "items_id" => $_POST["items_id"],
    ];

    $itemtype1_item->add([
        ...$data2,
        "comment" => $_POST["notification_text"],
    ]);



//    if ($itemtype_item->getFromDBByCrit($data2)) {
//        $itemtype_item->update([
//            ...$data2,
//            "comment" => $_POST["notification_text"],
//            "id" => $itemtype_item->fields["id"]
//        ]);
//    } else {
//        $itemtype_item->add([
//            ...$data2,
//            "comment" => $_POST["notification_text"],
//        ]);
//
//    }
}
//die();
Html::back();

