<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.
 --------------------------------------------------------------------------
*/
include("../../../inc/includes.php");
Session::checkRight("config", READ);
global $CFG_GLPI, $DB;

// 1) Récupérer et valider l’itemtype + option d’export
$itemtype_str = $_REQUEST['itemtype'] ?? '';
$exportOption = $_REQUEST['exportOption'] ?? ''; // “full”, “medium” ou “minimal”
$redirectUrl = $_SERVER['HTTP_REFERER'] ?? $CFG_GLPI['root_doc'];

if (!class_exists($itemtype_str)) {
    Html::displayErrorAndDie("Type d'objet invalide.");
}
$itemtype = new $itemtype_str();
$table = $itemtype::getTable();

// 2) Récupérer les données de la table principale
$res = $DB->request([
    'FROM' => $table,
    'WHERE' => ['entities_id' => Session::getActiveEntity()]
]);
if (!$res->numrows()) {
    Session::addMessageAfterRedirect("Aucune donnée à exporter.", 0, WARNING);
    Html::back();
}

// 3) Créer le .dat principal
$tmpfile_main = tempnam(GLPI_TMP_DIR, "export_main_") . ".dat";
$h_main = fopen($tmpfile_main, 'w');
$printed_main = false;
foreach ($res as $row) {
    if (!$printed_main) {
        fwrite($h_main, implode("\t", array_keys($row)) . "\n");
        $printed_main = true;
    }
    fwrite($h_main,
        implode("\t", array_map(function ($v) {
            return html_entity_decode($v === null ? '' : $v);
        }, $row)) . "\n"
    );
}
fclose($h_main);

// 4) Initialiser les chemins à null
$tmpfile_personnes = null;
$tmpfile_liceite = null;
$tmpfile_retention = null;

// 5) Selon l’option, générer les fichiers supplémentaires
if ($itemtype_str === PluginDlteamsPolicieForm::class) {
    // a) “full” : personnes, licéité, rétention
    if ($exportOption === 'full') {
        // Personnes & données
        $iter_pers = $DB->request(
            PluginDlteamsPolicieForm_PersonalAndDataCategory::getRequest(null, true)
        );
        $tmpfile_personnes = tempnam(GLPI_TMP_DIR, "export_pers_") . ".dat";
        $h_pers = fopen($tmpfile_personnes, 'w');
        $printed_p = false;
        foreach ($iter_pers as $row_p) {
            if (!$printed_p) {
                fwrite($h_pers, implode("\t", array_keys($row_p)) . "\n");
                $printed_p = true;
            }
            fwrite($h_pers,
                implode("\t", array_map(function ($v) {
                    return html_entity_decode($v === null ? '' : $v);
                }, $row_p)) . "\n"
            );
        }
        fclose($h_pers);

        // Licéité
        $iter_lic = PluginDlteamsLegalBasi_Item::getRequest(new PluginDlteamsPolicieForm(), true);
        $tmpfile_liceite = tempnam(GLPI_TMP_DIR, "export_liceite_") . ".dat";
        $h_liceite = fopen($tmpfile_liceite, 'w');
        $printed_l = false;
        foreach ($iter_lic as $row_l) {
            if (!$printed_l) {
                fwrite($h_liceite, implode("\t", array_keys($row_l)) . "\n");
                $printed_l = true;
            }
            fwrite($h_liceite,
                implode("\t", array_map(function ($v) {
                    return html_entity_decode($v === null ? '' : $v);
                }, $row_l)) . "\n"
            );
        }
        fclose($h_liceite);

        // Rétention
        $iter_ret = $DB->request(PluginDlteamsStoragePeriod_Item::getRetentionRequest(new PluginDlteamsPolicieForm(), true));
        $tmpfile_retention = tempnam(GLPI_TMP_DIR, "export_retention_") . ".dat";
        $h_retention = fopen($tmpfile_retention, 'w');
        $printed_r = false;
        foreach ($iter_ret as $row_r) {
            if (!$printed_r) {
                fwrite($h_retention, implode("\t", array_keys($row_r)) . "\n");
                $printed_r = true;
            }
            fwrite($h_retention,
                implode("\t", array_map(function ($v) {
                    return html_entity_decode($v === null ? '' : $v);
                }, $row_r)) . "\n"
            );
        }
        fclose($h_retention);
    } // b) “medium” : uniquement personnes & données
    elseif ($exportOption === 'medium') {
        $iter_pers = $DB->request(
            PluginDlteamsPolicieForm_PersonalAndDataCategory::getRequest(null, true)
        );
        $tmpfile_personnes = tempnam(GLPI_TMP_DIR, "export_pers_") . ".dat";
        $h_pers = fopen($tmpfile_personnes, 'w');
        $printed_p = false;
        foreach ($iter_pers as $row_p) {
            if (!$printed_p) {
                fwrite($h_pers, implode("\t", array_keys($row_p)) . "\n");
                $printed_p = true;
            }
            fwrite($h_pers,
                implode("\t", array_map(function ($v) {
                    return html_entity_decode($v === null ? '' : $v);
                }, $row_p)) . "\n"
            );
        }
        fclose($h_pers);
    }
    // c) “minimal” : aucun fichier supplémentaire
}


if ($itemtype_str === PluginDlteamsDeliverable::class) {
//     ecrire les paragraphes et les sections dans le fichier .dat de sortie
    $allchapter = $DB->request(
        [
            'SELECT' => [
                PluginDlteamsDeliverable_Section::getTable().".*"
            ],
            'FROM' => PluginDlteamsDeliverable_Section::getTable(),
            'ORDER' => ['timeline_position ASC'],
            'JOIN' => [
                PluginDlteamsDeliverable::getTable() => [
                    'FKEY' => [
                        PluginDlteamsDeliverable_Section::getTable() => "items_id",
                        PluginDlteamsDeliverable::getTable() => "id"
                    ]
                ],
            ],
            'WHERE' => [
                PluginDlteamsDeliverable_Section::getTable().'.itemtype' => PluginDlteamsDeliverable::class,
                PluginDlteamsDeliverable::getTable().'.entities_id' => Session::getActiveEntity()
            ]
        ]);
    

    $chapter_idx = [];
     // Si on a au moins une ligne, on peut ajouter ce bloc à la fin du fichier principal
    if ($allchapter->numrows()) {
        // Ouvrir en mode “append” pour ajouter au fichier .dat existant
        $h_main = fopen($tmpfile_main, 'a');
        if (!$h_main) {
            Html::displayErrorAndDie("Impossible d’ouvrir en écriture le fichier principal pour append.");
        }

        // 5.a.1) Écrire un marqueur pour indiquer le début du second bloc
        fwrite($h_main, "\n"); // ligne vide pour bien séparer des données précédentes
        fwrite($h_main, "# Début des sections : \n");

        // 5.a.2) Itérer les résultats et écrire l’en-tête une seule fois
        $printed_chapter_header = false;
        foreach ($allchapter as $chapter) {

            if(in_array($chapter["id"], $chapter_idx))
                $chapter_idx[] = $chapter["id"];

            if (!$printed_chapter_header) {
                // Les clés du premier élément de $chapter correspondent aux noms de colonnes
                fwrite($h_main, implode("\t", array_keys($chapter)) . "\n");
                $printed_chapter_header = true;
            }

            // Pour chaque ligne ($chapter), on découpe les valeurs et on écrit
            $fields = array_map(function ($v) {
                return html_entity_decode($v === null ? '' : $v);
            }, $chapter);

            fwrite($h_main, implode("\t", $fields) . "\n");
        }

        fclose($h_main);
    }

    

//     recuperer les paragraphes des sections
    // 5.b) Récupérer tous les paragraphes liés aux chapitres précédemment récupérés
    if (count($chapter_idx) > 0) {
        // Construire la requête pour les paragraphes
        $paragraphes_iteration = $DB->request([
            'FROM'  => PluginDlteamsDeliverable_Content::getTable(),
            'WHERE' => [
                'deliverable_sections_id' => $chapter_idx
            ],
            'ORDER' => ['timeline_position ASC']
        ]);

        // Si on a au moins un paragraphe, on écrit dans le même fichier
        if ($paragraphes_iteration->numrows()) {
            $h_main = fopen($tmpfile_main, 'a');
            if (!$h_main) {
                Html::displayErrorAndDie("Impossible d’ouvrir en écriture le fichier principal pour append (paragraphes).");
            }

            // 5.b.1) Écrire un marqueur pour indiquer le début du bloc "paragraphes"
            fwrite($h_main, "\n");
            fwrite($h_main, "# Début des paragraphes \n");

            // 5.b.2) Itérer les paragraphes et écrire l’en-tête une seule fois
            $printed_paragraph_header = false;
            foreach ($paragraphes_iteration as $para) {
                if (!$printed_paragraph_header) {
                    fwrite($h_main, implode("\t", array_keys($para)) . "\n");
                    $printed_paragraph_header = true;
                }
                $fields_para = array_map(function ($v) {
                    return html_entity_decode($v === null ? '' : $v);
                }, $para);
                fwrite($h_main, implode("\t", $fields_para) . "\n");
            }

            fclose($h_main);
        }
    }

}


// 6) Créer l’archive ZIP
$zipPath = tempnam(GLPI_TMP_DIR, "export_zip_") . ".zip";
$zip = new ZipArchive();
if ($zip->open($zipPath, ZipArchive::CREATE) !== true) {
    Html::displayErrorAndDie("Impossible de créer l'archive ZIP.");
}

// Ajouter le fichier principal
$zip->addFile($tmpfile_main, basename($tmpfile_main));
// Ajouter les autres s’ils existent
if ($tmpfile_personnes !== null) {
    $zip->addFile($tmpfile_personnes, basename($tmpfile_personnes));
}
if ($tmpfile_liceite !== null) {
    $zip->addFile($tmpfile_liceite, basename($tmpfile_liceite));
}
if ($tmpfile_retention !== null) {
    $zip->addFile($tmpfile_retention, basename($tmpfile_retention));
}
$zip->close();

// 7) Conserver le nom du ZIP pour le téléchargement
$zipFilename = basename($zipPath);

// 8) Afficher la page HTML qui déclenche le téléchargement et redirige ensuite
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Export ZIP</title>
    <script>
        window.onload = function () {
            // Lien pour télécharger le ZIP
            const a = document.createElement('a');
            a.href = '<?= $CFG_GLPI["root_doc"] ?>/marketplace/dlteams/front/download_zip.php?file=<?= $zipFilename ?>';
            a.download = '';
            document.body.appendChild(a);
            a.click();

            // Redirection après 2 secondes
            setTimeout(function () {
                window.location.href = '<?= $redirectUrl ?>';
            }, 2000);
        };
    </script>
</head>
<body>
<p>Préparation de votre export ZIP…</p>
</body>
</html>
