<?php
include("../../../inc/includes.php");

if (!Session::haveRight("user", UPDATE)) {
    Session::addMessageAfterRedirect("Vous n'avez pas les droits suffisants pour effectuer cette action", false, ERROR);
    Html::back();
}

global $DB;

/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
$expected = [];

// Choix de l'annuaire
$annuaire = isset($_POST['annuaire']) ? trim($_POST['annuaire']) : null;
if (!$annuaire) {
    Session::addMessageAfterRedirect("Aucun annuaire sélectionné", false, ERROR);
    Html::back();
}

$import_type = $_POST["type_import"];
switch ($import_type){
    case "users":

        $count_new_users_added_to_group = 0;
        $count_users_deleted_from_groups = 0;
        $count_ignored_because_exist_in_group = 0;
        $count_groups_ignored_because_not_exist = 0;
        $count_users_ignored_because_not_exist = 0;
        // Mapping attendu pour Microsoft 365 (Groupes)
        if ($annuaire === 'm365') {

            if (isset($_FILES['csvFile']) && $_FILES['csvFile']['error'] === UPLOAD_ERR_OK) {
                $fileTmpPath = $_FILES['csvFile']['tmp_name'];

                if (($handle = fopen($fileTmpPath, "r")) !== false) {
                    $header = fgetcsv($handle, 1000, ",");
                    if (!$header || !in_array('GroupId', $header) || !in_array('ObjectId', $header)) {
                        Session::addMessageAfterRedirect("Fichier CSV vide ou entêtes invalides.", false, ERROR);
                        fclose($handle);
                        Html::back();
                    }

                    $groupedData = [];

                    while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                        $row = array_combine($header, $data);
                        $groupUid = $row['GroupId'];
                        $objectId = $row['ObjectId'];

                        if (!isset($groupedData[$groupUid])) {
                            $groupedData[$groupUid] = [];
                        }

                        if (!in_array($objectId, $groupedData[$groupUid])) {
                            $groupedData[$groupUid][] = $objectId;
                        }
                    }

                    fclose($handle);

//                    on a donc quelque chose comme, chaque groupe avec ses utilisateurs
//                    Array
//(
//    [0c14a840-1059-4bc3-910c-1e4459e96e35] => Array
//        (
//            [0] => 5906f281-d445-4e30-90b2-b6a7287c5839
//            [1] => fb693ac5-5b7a-4fc6-b1bd-ac14d95936bb
//            [2] => 6458d6c1-87df-4fd5-a918-9d9182097fda
//            [3] => ad9cde5e-9d72-4c35-8777-03a64c6a2f58
//            [4] => 146ac46e-1aca-416c-9833-9a660b54fd68
//        )
//
//    [0d1d856a-e86c-4dc2-8000-c6e3d3e941c2] => Array
//        (
//            [0] => 5906f281-d445-4e30-90b2-b6a7287c5839
//            [1] => 54dbee7d-d387-4b56-9ddf-c7acbb2b0005
//            [2] => c421edd6-10fc-4fb7-a613-b083b525844c
//            [3] => 0c88f7c9-8058-429a-ba77-c541ae3dbb61
//            [4] => 7ad9c75e-a99d-49a2-a32c-16a8f58efa3c
//        ) )

                    foreach ($groupedData as $group_uid => $group_users) {
                        $group = new Group();

                        // Vérifie si un groupe avec ce GUID Microsoft existe en base
                        if ($group->getFromDBByCrit([
                            "microsoft_guid" => $group_uid
                        ])) {
                            // Groupe trouvé, synchronisation des utilisateurs
                            $groupUserObject = new Group_User();

                            if (!empty($group_users)) {
                                // Construire la clause NOT IN avec les IDs à conserver
                                $placeholders = implode("','", array_map('addslashes', $group_users));

                                $usersofgroup_query = [
                                    "SELECT" => ["id"],
                                    "FROM" => User::getTable(),
                                    "WHERE" => [
                                        "microsoft_guid NOT IN ('$placeholders')"
                                    ]
                                ];
                                $group_users_ids = [];
                                $usersofgroup_iterator = $DB->request($usersofgroup_query);
                                foreach ($usersofgroup_iterator as $group_users_object)array_push($group_users_ids, $group_users_object["id"]);

                                if(count($group_users_ids)){
                                    $placeholders = implode("','", array_map('addslashes', $group_users_ids));

                                    $groupUserObject_criteria = [
                                        "FROM" => $groupUserObject->getTable(),
                                        "WHERE" => [
                                            "groups_id" => $group->fields["id"],
                                            "users_id NOT IN ('$placeholders')"
                                        ]
                                    ];
                                    $iterator_groupUserObject = $DB->request($groupUserObject_criteria);
                                    $count_users_deleted_from_groups+=count($iterator_groupUserObject);
//                                supprimer les utilisateurs du group qui ne sont pas dans le groupement issu du prétraitement
                                    $groupUserObject->deleteByCriteria([
                                        "groups_id" => $group->fields["id"],
                                        "users_id NOT IN ('$placeholders')"
                                    ]);
                                }

//                                ajout des utilisateurs qui ne sont pas encore rattachés au groupe
                                foreach ($group_users as $gu){
                                    $user = new User();
                                    if($user->getFromDBByCrit([
                                        "microsoft_guid" => $gu
                                    ])){
//                                        utilisateur existe, verifions maintenant s'il est deja dans ce groupe
                                        $tempGroupUser = new Group_User();

                                        if(!$tempGroupUser->getFromDBByCrit([
                                            "users_id" => $user->fields["id"],
                                            "groups_id" => $group->fields["id"]
                                        ])){
//                                            il n'est pas dans ce groupe, ajoutons le
                                            $tempGroupUser->add([
                                                "users_id" => $user->fields["id"],
                                                "groups_id" => $group->fields["id"]
                                            ]);

                                            $count_new_users_added_to_group++;
                                        }
                                        else
                                            $count_ignored_because_exist_in_group++;
                                    }
                                    else
                                        $count_users_ignored_because_not_exist++;
                                }
                            }
                        }
                        else
                            $count_groups_ignored_because_not_exist++;
                    }

                }
            }

            Session::addMessageAfterRedirect(
                "$count_new_users_added_to_group utilisateur(s) ajouté(s) dans des groupes.",
                false,
                $count_new_users_added_to_group > 0 ? INFO : WARNING
            );

            Session::addMessageAfterRedirect(
                "$count_users_deleted_from_groups utilisateur(s) supprimé(s) de groupes.",
                false,
                $count_users_deleted_from_groups > 0 ? INFO : WARNING
            );

            Session::addMessageAfterRedirect(
                "$count_ignored_because_exist_in_group utilisateur(s) ignoré(s) car déjà présent(s) dans le(s) groupe(s).",
                false,
                $count_ignored_because_exist_in_group > 0 ? INFO : WARNING
            );

            Session::addMessageAfterRedirect(
                "$count_groups_ignored_because_not_exist groupe(s) ignoré(s) car non trouvés en base.",
                false,
                $count_groups_ignored_because_not_exist > 0 ? INFO : WARNING
            );

            Session::addMessageAfterRedirect(
                "$count_users_ignored_because_not_exist utilisateur(s) ignoré(s) car non trouvés en base.",
                false,
                $count_users_ignored_because_not_exist > 0 ? INFO : WARNING
            );


            Html::back();
        } else {
            Session::addMessageAfterRedirect("Annuaire non supporté pour les groupes.", false, ERROR);
            Html::back();
        }

        break;
    case "groups":
        // Mapping attendu pour Microsoft 365 (Groupes)
        if ($annuaire === 'm365') {
            $expected = [
                'name'            => 'DisplayName',
                'email'           => 'Mail',
                'microsoft_guid'  => 'Id'
            ];
        } else {
            Session::addMessageAfterRedirect("Annuaire non supporté pour les groupes.", false, ERROR);
            Html::back();
        }

// Vérifie que le fichier est uploadé
        if (isset($_FILES['csvFile']) && $_FILES['csvFile']['error'] === UPLOAD_ERR_OK) {
            $fileTmpPath = $_FILES['csvFile']['tmp_name'];

            if (($handle = fopen($fileTmpPath, "r")) !== false) {
                $header = fgetcsv($handle, 1000, ",");
                if (!$header) {
                    Session::addMessageAfterRedirect("Fichier CSV vide ou invalide.", false, ERROR);
                    fclose($handle);
                    Html::back();
                }

                // Création du mapping CSV ↔️ champs GLPI
                $mapping = [];
                foreach ($expected as $field => $label) {
                    $mapping[$field] = null;
                }

                foreach ($header as $index => $csvCol) {
                    foreach ($expected as $field => $expectedCol) {
                        if (strcasecmp(trim($csvCol), $expectedCol) === 0) {
                            $mapping[$field] = $index;
                        }
                    }
                }

                // Vérification que tous les champs sont bien présents
                foreach ($mapping as $field => $index) {
                    if ($index === null) {
                        Session::addMessageAfterRedirect("Colonne '{$expected[$field]}' manquante dans le fichier CSV.", false, ERROR);
                        fclose($handle);
                        Html::back();
                    }
                }

                $countAdd = 0;
                $countUpdate = 0;
                $countSkipped = 0;

                while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                    $record = [];

                    foreach ($mapping as $field => $index) {
                        $record[$field] = trim($data[$index]);
                    }

                    // Vérifie les données minimales
                    if (empty($record['microsoft_guid']) || empty($record['name'])) {
                        $countSkipped++;
                        continue;
                    }

                    // Ajoute l'entité active pour les nouveaux groupes
                    $record['entities_id'] = Session::getActiveEntity();

                    // Utilisation de l'objet GLPI natif
                    $group = new Group();

                    if ($group->getFromDBByCrit([
                        'microsoft_guid' => $record['microsoft_guid']
                    ])) {
                        // Update
                        $record['id'] = $group->getID();
                        /*                highlight_string("<?php\n\$data =\n" . var_export($record, true) . ";\n?>");*/
//                die();
                        if ($group->update($record)) {
                            $countUpdate++;
                        }
                    } else {
                        // Add
                        if ($group->add($record)) {
                            $countAdd++;
                        }
                    }
                }

                fclose($handle);

                Session::addMessageAfterRedirect("Importation des groupes terminée avec succès.", true);
                Session::addMessageAfterRedirect(sprintf("%d groupe(s) ajouté(s), %d mis à jour, %d ignoré(s)", $countAdd, $countUpdate, $countSkipped), true);
                Html::back();

            } else {
                Session::addMessageAfterRedirect("Impossible d'ouvrir le fichier CSV.", false, ERROR);
                Html::back();
            }
        } else {
            Session::addMessageAfterRedirect("Aucun fichier uploadé ou erreur de transfert.", false, ERROR);
            Html::back();
        }

        break;
}