<?php

use Glpi\Event;

include("../../../inc/includes.php");

if (isset($_POST["reply_to"])) {
    $_POST["parent_comment_id"] = $_POST["reply_to"];
    $parent = new ITILFollowup();
    $parent->getFromDB($_POST["parent_comment_id"]);

    $entities_id = $parent->fields["entities_id"];
}

// Vérifier la session utilisateur
Session::checkLoginUser();

// Si la discussion est fermée
if (isset($_POST["close"])) {
    handleCloseRequest();
    Html::back();
}

if (isset($_POST["send_notification"])) {
    handleNotification($_POST);
}


// Vérification des champs obligatoires
//if (!isset($_POST['items_id'])) {
//    handleError(__('Mandatory fields are not filled!'));
//}

// Validation de l'élément cible
if(isset($_POST["itemtype"]) && isset($_POST['items_id'])){
    $itemtype_str = $_POST["itemtype"];

    if($itemtype_str == PluginDlteamsMessage::class){
        $itemtype_str = User::class;
        $_POST['itemtype'] = User::class;
        $_POST['items_id'] = Session::getLoginUserID();
    }

    $kbitem = new $itemtype_str();

    if (!$kbitem->getFromDB($_POST['items_id'])) {
        Html::displayRightError();
    }
}

if (isset($_POST["move_message"])) {
    handleMoveRequest();
    Html::back();
}

$comment = new ITILFollowup();

// Gestion des actions
if (isset($_POST["add"]) && !isset($_POST["edit"])) {
    handleAddOrReplyRequest($comment);
    $items_id = $_POST["items_id"];
    $itemtype_str = $_POST["itemtype"];
    Html::redirect($itemtype_str::getFormURLWithID($items_id)."&forcetab=PluginDlteamsMessage$1");
} elseif (isset($_POST["edit"])) {
    handleEditRequest($comment);
    $items_id = $_POST["items_id"];
    $itemtype_str = $_POST["itemtype"];
    Html::redirect($itemtype_str::getFormURLWithID($items_id)."&forcetab=PluginDlteamsMessage$1");
} elseif (isset($_POST["delete"])) {
    handleDeleteRequest();
    $items_id = $_POST["items_id"];
    $itemtype_str = $_POST["itemtype"];
    Html::redirect($itemtype_str::getFormURLWithID($items_id)."&forcetab=PluginDlteamsMessage$1");
} else {
    $message = new PluginDlteamsMessage();
    $message->checkGlobal(READ);

    if (Session::getCurrentInterface() == 'central') {
        Html::header(PluginDlteamsMessage::getTypeName(2), '', "helpdesk", "plugindlteamsmessage");
    } else {
        Html::helpHeader(PluginDlteamsMessage::getTypeName(0));
    }

    $message->display(['id' => isset($_GET['id'])?$_GET['id']:null]);

    if (Session::getCurrentInterface() == 'central') {
        Html::footer();
    } else {
        Html::helpFooter();
    }
}

// Retour au formulaire

/**
 * Gestion de la fermeture d'une discussion.
 */
function handleCloseRequest()
{
    global $DB;
    $fp = new ITILFollowup();

    $DB->update(
        $fp->getTable(),
        ["solved_state" => 1],
        ["itemtype" => $_POST["itemtype"], "items_id" => $_POST["items_id"]]
    );

    Session::addMessageAfterRedirect("Discussion close avec succès", false, INFO);
}

/**
 * Gestion de l'ajout d'un commentaire ou d'une réponse.
 */
function handleAddOrReplyRequest($comment)
{
    global $DB;
    if (!isset($_POST['content'])) {
        handleError(__('Mandatory fields are not filled!'));
    }

    $data = prepareCommentData($_POST);

    if (isset($_POST["reply_to"])) {
        $_POST["parent_comment_id"] = $_POST["reply_to"];
        $parent = new ITILFollowup();
        $parent->getFromDB($_POST["parent_comment_id"]);

        $data["entities_id"] = $parent->fields["entities_id"];
    }

    if (!empty($data["parent_comment_id"])) {
        // Vérification que le commentaire parent existe
        $parentComment = new ITILFollowup();
        if (!$parentComment->getFromDB($data["parent_comment_id"])) {
            handleError(__('The parent comment does not exist!'));
        }
    }

/*    highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");*/

    if ($DB->insert($comment->getTable(), $data)) {
        $action = empty($data["parent_comment_id"]) ? __('adds a comment on knowledge base') : __('replies to a comment');
        logEvent($data["items_id"], $data["itemtype"], $action);
//        Session::addMessageAfterRedirect(
//            "<a href='#'>" . __('Your comment or reply has been added') . "</a>",
//            false,
//            INFO
//        );


        $users_idx = [];

        if (in_array($data["itemtype"], [TicketTask::class, PluginDlteamsTicketTask::class])) {
            $tickettask = new TicketTask();
            $tickettask->getFromDB($data["items_id"]);
            $users_idx[$tickettask->fields["users_id"]] = $tickettask->fields["users_id"];
            $users_idx[$tickettask->fields["users_id_editor"]] = $tickettask->fields["users_id_editor"];

//            tous les users de l'entité
            $query = [
                "FROM" => User::getTable(),
                "WHERE" => [
                    "entities_id" => Session::getActiveEntity()
                ]
            ];

            global $DB;
            $iterator = $DB->request($query);
            foreach ($iterator as $tt) {
                $users_idx[$tt["id"]] = $tt["id"];
            }


        }


//        unset($users_idx[Session::getLoginUserID()]);

        $notification = new NotificationAjax();
        $fullname = $_SESSION["glpifirstname"] . " " . $_SESSION["glpirealname"];
        isset($_POST["edit"]) ? $subject = "Message édité" : $subject = "Nouveau message";

        foreach ($users_idx as $id => $user) {
            $notification->sendNotification([
                '_itemtype' => $data["itemtype"],
                '_items_id' => $data["items_id"],
                '_notificationtemplates_id' => 0,
                '_entities_id' => 0,
                'fromname' => $fullname,
                'subject' => $subject,
                'content_text' => strip_tags(html_entity_decode($data["content"])),
                'to' => $id,
                'event' => 'message_notification'
            ]);
        }
    }
}

/**
 * Gestion de la modification d'un commentaire.
 */
function handleEditRequest($comment)
{
    global $DB;
    if ($_POST['edit'])
        $_POST['id'] = $_POST['edit'];

    if (!isset($_POST['id']) || !isset($_POST['content'])) {
        handleError(__('Mandatory fields are not filled!'));
    }

    $comment->getFromDB($_POST['id']);

    if (empty($_POST['content'])) {
        $comment->delete(["id" => $_POST['id']]);
        Session::addMessageAfterRedirect("Message supprimé");
        Html::back();
    }
    $data = array_merge($comment->fields, $_POST);

    // Suppression des champs inutiles
    $data = filterCommentData($data);

    if(isset($data["_content"]))
        unset($data["_content"]);
    if(isset($data["_prefix_content"]))
        unset($data["_prefix_content"]);
    if(isset($data["_tag_content"]))
        unset($data["_tag_content"]);

    if ($DB->update($comment->getTable(), [...$data, "date_mod" => $_SESSION['glpi_currenttime']], ['id' => $_POST['id']])) {
        logEvent($data["items_id"], $data["itemtype"], __('Your comment has been edited'));
        Session::addMessageAfterRedirect(
            "<a href='#kbcomment{$comment->getID()}'>" . __('Your comment has been edited') . "</a>",
            false,
            INFO
        );
    }
}


/**
 * Gestion de la suppression d'un commentaire.
 */
function handleDeleteRequest()
{
    $comment = new ITILFollowup();

    if (!isset($_POST["id"])) {
        handleError(__('No comment ID provided!'));
    }

    if ($comment->delete(["id" => $_POST["id"]])) {
        Session::addMessageAfterRedirect(__('Comment deleted successfully'), false, INFO);
    }
}

/**
 * Prépare les données pour un commentaire (ajout ou réponse).
 */
function prepareCommentData($postData)
{

    if (isset($postData["parent_comment_id"])) {
        $if = new ITILFollowup();
        $if->getFromDB($postData["parent_comment_id"]);
        $postData["itemtype"] = $if->fields["itemtype"];
        $postData["items_id"] = $if->fields["items_id"];
    }


    if(!isset($entities_id)){
        $entities_id = $_SESSION['glpiactive_entity']??0;
    }

    return [
        "itemtype" => $postData["itemtype"],
        "items_id" => $postData["items_id"],
        "content" => $postData["content"],
        "parent_comment_id" => $postData["parent_comment_id"] ?? null, // ID du message parent
        "users_id" => Session::getLoginUserID(),
        "users_id_editor" => Session::getLoginUserID(),
        "requesttypes_id" => 0,
        "timeline_position" => 0,
        "sourceof_items_id" => 0,
        "sourceitems_id" => 0,
        "entities_id" => isset($entities_id) ? $entities_id : $_SESSION['glpiactive_entity'],
        "date_creation" => $_SESSION["glpi_currenttime"],
        "date_mod" => $_SESSION["glpi_currenttime"]
    ];
}


function handleMoveRequest()
{
    $message_id = $_POST["message_id"];
    $message = new ITILFollowup();
    $message->getFromDB($message_id);
    global $DB;
    $DB->update($message->getTable(),
        [
            "itemtype" => $_POST["itemtype"],
            "items_id" => $_POST["items_id"]
        ],
        [
            "id" => $message_id
        ]
    );

    $DB->update($message->getTable(), [
        "itemtype" => $_POST["itemtype"],
        "items_id" => $_POST["items_id"]
    ],
        [
            "id" => $message_id
        ]);

    if ($message->fields["parent_comment_id"])
        $DB->update($message->getTable(), [
            "itemtype" => $_POST["itemtype"],
            "items_id" => $_POST["items_id"]
        ],
            [
                "parent_comment_id" => $message_id
            ]);

//    die();
    Session::addMessageAfterRedirect("Message déplacé avec succès");


}

/**
 * Filtre les données pour un commentaire modifié.
 */
function filterCommentData($data)
{
    unset($data['_glpi_csrf_token'], $data['edit'], $data['add'], $data['_uploader_content'], $data['itemtype'], $data['items_id']);
    return $data;
}


function handleNotification($data)
{

//    itemtype1 is the current object
//    itemtype is the receiver

/*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();

    if (!isset($_POST["itemtype"]) || !isset($_POST["items_id"]) || !$_POST["itemtype"] || !$_POST["items_id"]) {
        Session::addMessageAfterRedirect("Action invalide", false, ERROR);
        Html::back();
    }

    $itemtype = $_POST["itemtype"];
    $itemtype1 = isset($_POST["itemtype1"])?$_POST["itemtype1"]:$_POST["itemtype"];
    $items_id = $_POST["items_id"];
    $items_id1 = isset($_POST["items_id1"])?$_POST["items_id1"]:$_POST["items_id"];

    $receiver = new $itemtype();
    $receiver->getFromDB($items_id);
    $name = " ";


    if ($receiver) {
        switch ($itemtype) {
            case Contact::class:
            case Supplier::class:

                $receiver_mail = $_POST["email"] ?? $receiver->fields["email"];
                $name = sprintf("%s %s", isset($receiver->fields["firstname"])?$receiver->fields["firstname"]:"", $receiver->fields["name"]);
                if (!$receiver_mail) {
                    Session::addMessageAfterRedirect("Adresse mail du destinataire invalide", 0, ERROR);
                    Html::back();
                }
                break;
            default:
                //            le destinataire est un user
                $receiver_mail = UserEmail::getDefaultForUser($receiver->fields["id"]);
                $name = sprintf("%s %s", $receiver->fields["firstname"], $receiver->fields["realname"]);
                break;
        }



        if (!NotificationMailing::isUserAddressValid($receiver_mail)) {
            Session::addMessageAfterRedirect("Le destinataire ne possede pas d'adresse email valide ($receiver_mail)", false, WARNING);
            Html::back();
        }

    } else {
        Session::addMessageAfterRedirect("Destinataire non trouvé", false, WARNING);
        Html::back();
    }

    $fupi = new ITILFollowup();
    global $CFG_GLPI;
    $fromemail = $CFG_GLPI['smtp_username'];
    $objet = $_POST["object_notification"];
    $htmlcontent = "<b>De: </b> $fromemail <$fromemail> <br/>";
    $htmlcontent .= "<b>À :</b> $name ($receiver_mail) <br/>";
    $htmlcontent .= "<b>Objet :</b> $name ($receiver_mail) <br/>";
    $htmlcontent .= html_entity_decode($_POST["notification_text"]);
    global $DB;
    $DB->insert($fupi->getTable(), [
        "itemtype" => $itemtype1,
        "items_id" => $items_id1,
        "content" => $htmlcontent,
        "date_creation" => $_SESSION["glpi_currenttime"],
        "date_mod" => $_SESSION["glpi_currenttime"],
        "users_id" => Session::getLoginUserID(),
        "type" => PluginDlteamsMessage::SENDMAIL
    ]);

    $data = [
        "subject" => $objet,
        "content_html" => $htmlcontent,
        "to" => $receiver_mail,  // the name here is an email
        "toname" => $receiver_mail,
    ];

    $mail = new PluginDlteamsNotificationMail();
    if ($mail->sendNotification($data)) {
        $saveitem = true;
        Session::addMessageAfterRedirect("Notification envoyé");
    } else {
        Session::addMessageAfterRedirect("Notification non envoyé", false, ERROR);
    }

    Html::back();
}

/**
 * Gère les erreurs en ajoutant un message et en redirigeant.
 */
function handleError($message)
{
    Session::addMessageAfterRedirect($message, false, ERROR);
    Html::back();
}

/**
 * Journalise un événement dans le système.
 */
function logEvent($itemsId, $itemType, $message)
{
    Event::log(
        $itemsId,
        strtolower($itemType),
        4,
        "tracking",
        sprintf(__('%s %s'), $_SESSION["glpiname"], $message)
    );
}
