<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */
 
include("../../../inc/includes.php");

if (!isset($_GET['id'])) {
   $_GET['id'] = "";
}

$processeddata = new PluginDlteamsProcessedData();

if (isset($_POST['add'])) {

   $processeddata->check(-1, CREATE, $_POST);
   $id = $processeddata->add($_POST);
   if($id)
    Html::redirect($processeddata->getFormURLWithID($id));
   else{
       Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
       Html::back();
   }

} else if (isset($_POST['update'])) {

   $processeddata->check($_POST['id'], UPDATE);
   $processeddata->update($_POST);
   Html::back();

} else if (isset($_POST['delete'])) {

   $processeddata->check($_POST['id'], DELETE);
   $processeddata->delete($_POST);
   $processeddata->redirectToList();

} else if (isset($_POST['purge'])) {

   $processeddata->check($_POST['id'], PURGE);
   $processeddata->delete($_POST, true);
   $processeddata->redirectToList();

}
else if (isset($_POST["restore"])) {
    $processeddata->check($_POST["id"], DELETE);

    $processeddata->restore($_POST);
    \Glpi\Event::log(
        $_POST["id"],
        "processeddata",
        4,
        "maintain",
        //TRANS: %s is the user login
        sprintf(__('%s restores an item'), $_SESSION["glpiname"])
    );
    $processeddata->redirectToList();
}
else {

   $processeddata->checkGlobal(READ);

   if (Session::getCurrentInterface() == 'central') {
//       Html::header(PluginDlteamsProcessedData::getTypeName(2), '', "datagovernance","datagovernancedcp", "processeddata");

       $menus = ["datagovernance", "datagovernancedcp", "processeddata"];
       PluginDlteamsProcessedData::displayFullPageForItem($_GET['id'], $menus, [
           'formoptions'  => "data-track-changes=true",
       ]);
   } else {
      Html::helpHeader(PluginDlteamsProcessedData::getTypeName(0));
   }

   $processeddata->display(['id' => $_GET['id']]);

   if (Session::getCurrentInterface() == 'central') {
      Html::footer();
   } else {
      Html::helpFooter();
   }

}