<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PlugindlteamsAutoReport extends PluginReportsAutoReport
{

    private $criterias       = [];
    private $columns         = [];
    private $group_by        = [];
    private $columns_mapping = [];
    private $sql             = "";
    private $name            = "";
    private $subname         = "";
    private $cpt             = 0;
    private $title           = '';
    private $plug           = '';

    /**
     * Execute the report
     *
     * @param $options   array
     **/
    function execute($options=[]) {
        global $DB, $CFG_GLPI, $HEADER_LOADED;

        // Require (for pager) when not called by displayCriteriasForm
        $this->manageCriteriasValues();

        if (isset ($_POST['list_limit'])) {
            $_SESSION['glpilist_limit'] = $_POST['list_limit'];
            unset ($_POST['list_limit']);
        }

        $limit = $_SESSION['glpilist_limit'];

        if (isset ($_POST["display_type"])) {
            $output_type = $_POST["display_type"];
            if ($output_type < 0) {
                $output_type = - $output_type;
                $limit       = 0;
            }
        } else {
            $output_type = Search::HTML_OUTPUT;
        }


        $title = $this->title;
        if ($this->subname) {
            $title = sprintf(__('%1$s - %2$s'), $title, $this->subname);
        }

        $res   = $DB->query($this->sql);
        $nbtot = ($res ? $DB->numrows($res): 0);
        if ($limit) {
            $start = (isset ($_GET["start"]) ? intval($_GET["start"]) : 0);
            if ($start >= $nbtot) {
                $start = 0;
            }
            if (($start > 0) || (($start + $limit) < $nbtot)) {
                $res = $DB->query($this->sql . " LIMIT $start,$limit");
            }
        } else {
            $start = 0;
        }

        if ($nbtot == 0) {
            if (!$HEADER_LOADED) {
                Html::header($title, $_SERVER['PHP_SELF'], "utils", "report");
                Report::title();
            }
            echo "<div class='center'><font class='red b'>".__('No item found')."</font></div>";
            Html::footer();
        } else if ($output_type == Search::HTML_OUTPUT) {
            if (!$HEADER_LOADED) {
                Html::header($title, $_SERVER['PHP_SELF'], "utils", "report");
                Report::title();
            }
            echo "<div class='center'><table class='tab_cadre_fixe'>";
            echo "<tr><th>".$title."</th></tr>\n";
            echo "<tr class='tab_bg_2 center'><td class='center'>";
            echo "<form method='POST' action='" .$_SERVER["PHP_SELF"] . "?start=$start'>\n";

            $param = "";
            foreach ($_POST as $key => $val) {
                if (is_array($val)) {
                    foreach ($val as $k => $v) {
                        echo Html::hidden($key.[$k], ['value' => $v]);
                        if (!empty ($param)) {
                            $param .= "&";
                        }
                        $param .= $key."[".$k."]=".urlencode($v);
                    }
                } else {
                    echo Html::hidden($key, ['value' => $val]);
                    if (!empty ($param)) {
                        $param .= "&";
                    }
                    $param .= "$key=" . urlencode($val);
                }
            }
            Dropdown::showOutputFormat();
//          echo "<button name='publish_dlteams' class='btn btn-md btn-primary' style='margin-left: 0.5rem;' title='Exporter'>Publier Dlteams</button>";
            Html::closeForm();
            echo "</td></tr>";
            echo "</table></div>";

            Html::printPager($start, $nbtot, $_SERVER['PHP_SELF'], $param);
        }


        $field = 'plugin_reports_'.$this->name;
        if ($this->plug != 'reports') {
            $field = 'plugin_reports_'.$this->plug."_".$this->name;
        }


        Session::checkRight($field, READ);

        if ($res && ($nbtot > 0)) {
            if (!isset ($_POST["display_type"]) || ($_POST["display_type"] == Search::HTML_OUTPUT)) {
                if (isset($options['withmassiveaction']) && class_exists($options['withmassiveaction'])) {
                    $massformid = 'massform'.$options['withmassiveaction'];
                    Html::openMassiveActionsForm($massformid);
                    Html::showMassiveActions(['container' => $massformid]);
                }
            }

            $nbcols = $DB->numFields($res);
            $nbrows = $DB->numrows($res);

            echo Search::showHeader($output_type, $nbrows, $nbcols, true);
            echo Search::showNewLine($output_type);
            $num = 1;

            // fill $sqlcols with default sql query fields so we can validate $columns
            $sqlcols = [];
            for ($i = 0 ; $i < $nbcols ; $i++) {
                $colname   = $DB->fieldName($res, $i);
                $sqlcols[] = $colname;
            }
            $colsname = [];
            // if $columns is not empty, display $columns
            if (count($this->columns) > 0) {
                foreach ($this->columns as $colname => $column) {
                    // display only $columns that are valid
                    if (in_array($colname, $sqlcols)) {
                        $column->showTitle($output_type, $num);
                        $colsname[$colname] = $column;
                    }
                }
            } else { // else display default columns from SQL query
                foreach ($sqlcols as $colname) {
                    $column = new PluginReportsColumn($colname, $colname);
                    $column->showTitle($output_type, $num);
                    $colsname[$colname] = $column;
                }
            }

            echo Search::showEndLine($output_type);

            $prev = "";
            for ($row_num = 2 ; $row = $DB->fetchAssoc($res); $row_num++) {
                $crt = "";
                foreach ($this->group_by as $colname) {
                    if (isset ($row[$colname])) {
                        $crt .= $row[$colname] . "####";
                    }
                }

                echo Search::showNewLine($output_type);
                $num = 1;

                foreach ($colsname as $colname => $column) {

                    //If value needs to be modified on the fly
                    if (isset ($this->columns_mapping[$colname])
                        && isset ($this->columns_mapping[$colname][$row[$colname]])) {

                        $new_value = $this->columns_mapping[$colname][$row[$colname]];
                        $row[$colname] = $new_value;
                    }

                    if (!in_array($colname, $this->group_by)) {
                        $column->showValue($output_type, $row, $num, $row_num);
                    } else if ($crt == $prev) {
                        $column->showValue($output_type,
                            (($output_type == Search::CSV_OUTPUT) ? $row : []),
                            $num, $row_num);
                    } else {
                        $column->showValue($output_type, $row, $num, $row_num, true);
                    }
                } // Each column
                echo Search::showEndLine($output_type);
                $prev = $crt;
            } // Each row

            if (isset($options['withtotal']) && $options['withtotal']) {
                echo Search::showNewLine($output_type);
                $num = 1;

                foreach ($colsname as $colname => $column) {
                    $column->showTotal($output_type, $num, $row_num);
                }

                echo Search::showEndLine($output_type);
            }
            echo Search::showFooter($output_type, $title);

            if (!isset ($_POST["display_type"]) || ($_POST["display_type"] == Search::HTML_OUTPUT)) {
                if (isset($options['withmassiveaction']) && class_exists($options['withmassiveaction'])) {
                    Html::showMassiveActions(['container' => $massformid,
                        'ontop'     => false]);
                    Html::closeForm();
                }
                Html::footer();
            }
        }
    }
}