<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;


define('age_digital_maturity', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);

define('dependancy_status', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);

define('ability_understant_record', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);

define('socio_economic_or_legal_situation', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);



//class PluginDlteamsConcernedPerson extends CommonDBTM implements
class PluginDlteamsConcernedPerson extends CommonDropdown implements
    PluginDlteamsExportableInterface
{
    use PluginDlteamsExportable;


    static $rightname = 'plugin_dlteams_concernedperson';
    public static $menukey = "datagovernanceconcernedperson";
    public $dohistory = true;
    protected $usenotepad = true;

    public const LOW    = 1;
    public const MEDIUM = 2;
    public const HIGH   = 3;

    // Libellés associés
    private const LABELS = [
        self::LOW    => 'Risque faible',
        self::MEDIUM => 'Moyen',
        self::HIGH   => 'Vulnérable',
    ];

    static function getTypeName($nb = 0)
    {
        return _n("Concerned person", "Concerned persons", $nb, 'dlteams');
    }

    function showForm($id, $options = [])
    {
        global $CFG_GLPI;

        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 25%;
            }
            
            
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

        echo "</style>";
        echo "<table, th, td width='100%'>";


        echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Ranking (order)", 'dlteams') . "</td>";
        echo "<td colspan='1'>";
        $number = Html::cleanInputText($this->fields['ranking']);
        echo "<input type='number' min='1' max='999' name='ranking' size='8' value='" . $number . "'>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";


        echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Name", 'dlteams') . "</td>";
        echo "<td>";
        $name = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:98%' name='name' required value='" . $name . "'>" . "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";

        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Content", 'dlteams') . "</td>";
        echo "<td>";
        $content = Html::cleanInputText($this->fields['content']);
        echo "<textarea style='width: 98%;' name='content' rows='3'>" . $content . "</textarea>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";

        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Comment", 'dlteams') . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width: 98%;' name='comment' rows='3'>" . $comment . "</textarea>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";
        echo "</table>";



        $this->initForm($id, $options);
        $this->showFormHeader($options);
        echo "<table class='tab_cadre_fixe' style='width:100%;margin-bottom:16px;'>";
        echo "<colgroup>
                <col style='width:50%'>
                <col style='width:50%'>
              </colgroup>";
        echo "<tr class='tab_bg_1'><th colspan='2'>" . __('Volumétrie et vulnérabilité des personnes concernées') . "</th></tr>";

        echo "<tr>";
        echo "<td class='form-table-text'>" . __("Nombre de personnes de cette catégorie dont les données sont actuellement stockées", 'dlteams') . "</td>";
        $number = Html::cleanInputText($this->fields['number']);
        echo "<td><input type='number' min='0' name='number' size='8' value='" . $number . "'>";
        echo "<input type='hidden' name='id' size='8' value='" . $id . "'></td>";
        echo "</tr>";

        echo "<tr>";
        echo "<td class='form-table-text'>" . __("Nombre d’entrants par an", 'dlteams') . "</td>";
        $newperyear = Html::cleanInputText($this->fields['newperyear']);
        echo "<td><input type='number' min='0' name='newperyear' size='8' value='" . $newperyear . "'></td>";
        echo "</tr>";

        echo "<tr>";
        echo "<td class='form-table-text'>" . __("Nombre de sortants (suppression et anonymisation suite à la finalité des traitements atteints)", 'dlteams') . "</td>";
        $deletedperyear = Html::cleanInputText($this->fields['deletedperyear']);
        echo "<td><input type='number' min='0' name='deletedperyear' size='8' value='" . $deletedperyear . "'></td>";
        echo "</tr>";

        echo "<tr>";
        echo "<td class='form-table-text'>" . __("Cette comptabilisation est-elle déjà effectuée dans une autre catégorie", 'dlteams') . "</td>";
        echo "<td>";
        Dropdown::showYesNo('accounted', $this->fields['accounted']);
        echo "</td>";
        echo "</tr>";

        if ($this->fields['accounted']) {
            echo "<tr>";
            echo "<td class='form-table-text'>" . PluginDlteamsConcernedPerson::getTypeName() . "</td>";
            echo "<td>";
            PluginDlteamsConcernedPerson::dropdown([
                'addicon' => PluginDlteamsConcernedPerson::canCreate(),
                'name' => 'evenaccounted_id',
                'used' => [$id],
                'value' => $this->fields["evenaccounted_id"],
                'width' => '200px'
            ]);
            echo "</td>";
            echo "</tr>";
        }

        echo "<tr class='tab_bg_2'><td colspan='2' class='center'>";
        echo "<input type='submit' name='update' value=\"" . __s('Save') . "\" class='btn btn-primary'></td></tr>";
        echo "</table>";
        Html::closeForm();







        $this->initForm($id, $options);
        $this->showFormHeader($options);
        echo "<table class='tab_cadre_fixe' style='width:100%;margin-bottom:16px;'>";
        echo "<colgroup>
        <col style='width:50%'>
        <col style='width:50%'>
      </colgroup>";
        echo "<tr class='tab_bg_1'><th colspan='2'>" . __('Critères de vulnérabilité des personnes concernées', 'dlteams') . "</th></tr>";

        echo "<input type='hidden' name='id' size='8' value='" . $id . "'></td>";
        // 1. Âge et maturité numérique
        echo "<tr>";
        echo "<td class='form-table-text'>";
        echo __("Âge et maturité numérique", "dlteams") . " ";
        Html::showToolTip(__("Personnes mineures, âgées ou peu à l’aise avec le numérique", "dlteams"));
        echo "</td>";
        echo "<td>";
        
        Dropdown::showFromArray(
            'age_and_digital_maturity',
            [1 => __('Risque faible', 'dlteams'), 2 => __('Moyen', 'dlteams'), 3 => __('Vulnérable', 'dlteams')],
            ['value' => $this->fields['age_and_digital_maturity'], 'width' => '150px']
        );
        echo "</td>";
        echo "</tr>";


        // 2. Situation de dépendance
        echo "<tr>";
        echo "<td class='form-table-text'>";
        echo __("Situation de dépendance", "dlteams") . " ";
        Html::showToolTip(__("Employés, patients, étudiants, clients captifs", "dlteams"));
        echo "</td>";
        echo "<td>";
        Dropdown::showFromArray(
            'dependency_situation',
            [1 => __('Risque faible', 'dlteams'), 2 => __('Moyen', 'dlteams'), 3 => __('Vulnérable', 'dlteams')],
            ['value' => $this->fields['dependency_situation'], 'width' => '150px']
        );
        echo "</td>";
        echo "</tr>";

        // 3. Capacité à comprendre un traitement
        echo "<tr>";
        echo "<td class='form-table-text'>";
        echo __("Capacité à comprendre un traitement", "dlteams") . " ";
        Html::showToolTip(__("Complexité de l’information, transparence, compréhension limitée", "dlteams"));
        echo "</td>";
        echo "<td>";
        Dropdown::showFromArray(
            'record_understanding_ability',
            [1 => __('Risque faible', 'dlteams'), 2 => __('Moyen', 'dlteams'), 3 => __('Vulnérable', 'dlteams')],
            ['value' => $this->fields['record_understanding_ability'], 'width' => '150px']
        );
        echo "</td>";
        echo "</tr>";

        // 4. Situation socio-économique ou juridique
        echo "<tr>";
        echo "<td class='form-table-text'>";
        echo __("Situation socio-économique ou juridique", "dlteams") . " ";
        Html::showToolTip(__("Personnes précaires, réfugiés, endettées", "dlteams"));
        echo "</td>";
        echo "<td>";
        Dropdown::showFromArray(
            'socioeconomic_or_legal_situation',
            [1 => __('Risque faible', 'dlteams'), 2 => __('Moyen', 'dlteams'), 3 => __('Vulnérable', 'dlteams')],
            ['value' => $this->fields['socioeconomic_or_legal_situation'], 'width' => '150px']
        );
        echo "</td>";
        echo "</tr>";

        // Aperçu du résultat
//        $c1 = (int) $this->fields['age_and_digital_maturity'];
//        $c2 = (int) $this->fields['dependency_situation'];
//        $c3 = (int) $this->fields['record_understanding_ability'];
//        $c4 = (int) $this->fields['socioeconomic_or_legal_situation'];
//        $filled = 0;
//        foreach ([$c1, $c2, $c3, $c4] as $v) { if ($v > 0) $filled++; }
//        $moyenne = $filled ? ($c1 + $c2 + $c3 + $c4) / $filled : 0;
//        if ($moyenne < 1.5) { $apercu = __('Risque faible', 'dlteams'); }
//        elseif ($moyenne < 2.5) { $apercu = __('Moyen', 'dlteams'); }
//        else { $apercu = __('Vulnérable', 'dlteams'); }

        $result = static::computeVulnerability($this);
        $moyenne = $result["moyenne"];
        $apercu = $result["apercu"];
        echo "<tr>";
        echo "<td class='form-table-text'><b>" . __('Aperçu du niveau global', 'dlteams') . "</b></td>";
        echo "<td><b>" . $apercu . "</b> <span style='color:#888'>(moyenne = " . round($moyenne, 2) . ")</span></td>";
        echo "</tr>";

        // Bouton enregistrer
        echo "<tr class='tab_bg_2'><td colspan='2' class='center'>";
        echo "<input type='submit' name='update' value=\"" . __s('Save') . "\" class='btn btn-primary'>";
        echo "</td></tr>";

        echo "</table>";

        Html::closeForm();

//        responsive
        echo "<style>
            .glpi-responsive-table {
                  width: 100%;
                  overflow-x: auto;
                }
                
                .glpi-responsive-table table {
                  width: 100%;
                  border-collapse: collapse;
                  min-width: 600px; /* empêche la casse sur les petits écrans */
                }
                
                @media screen and (max-width: 768px) {
                  .tab_cadre_fixe th,
                  .tab_cadre_fixe td,
                  .tab_cadre_fixehov th,
                  .tab_cadre_fixehov td {
                    font-size: 14px;
                    padding: 8px;
                  }
                
                  .btn,
                  input[type='submit'] {
                    width: 100%;
                    margin-top: 8px;
                  }
                }
                
                .td-fixed-small {
                  width: 2%;
                }
                
                @media screen and (max-width: 768px) {
                  .td-fixed-small {
                    width: fit-content !important;
                    white-space: nowrap;
                  }
                }
        </style>";

    }

    public static function computeVulnerability(PluginDlteamsConcernedPerson $concernedPerson){
        $c1 = (int) $concernedPerson->fields['age_and_digital_maturity'];
        $c2 = (int) $concernedPerson->fields['dependency_situation'];
        $c3 = (int) $concernedPerson->fields['record_understanding_ability'];
        $c4 = (int) $concernedPerson->fields['socioeconomic_or_legal_situation'];

        $vals = array_filter([$c1, $c2, $c3, $c4], fn($v) => $v > 0); // ignore les non-renseignés (0)
        $filled = count($vals);

        $cat = function (float $s): string {
            if ($s < 1.5)       return __('Risque faible', 'dlteams');
            elseif ($s < 2.5)   return __('Moyen', 'dlteams');
            else                return __('Vulnérable', 'dlteams');
        };

        $moyenne = $filled ? array_sum($vals) / $filled : 0;
        $apercu  = $cat($moyenne);

// --- Plus grande vulnérabilité (valeur max) ---
        $max_val = $filled ? max($vals) : 0;
        $apercu_max = $cat($max_val);

// Identifier la/les dimension(s) qui portent ce maximum (en cas d’égalité)
        $labels = [
            'age_and_digital_maturity',
            'dependency_situation',
            'record_understanding_ability',
            'socioeconomic_or_legal_situation',
        ];
        $all    = [$c1, $c2, $c3, $c4];

        $dimensions_max = [];
        if ($filled) {
            foreach ($all as $i => $v) {
                if ($v === $max_val && $v > 0) {
                    $dimensions_max[] = $labels[$i];
                }
            }
        }

        return [
            "apercu"         => $apercu,
            "moyenne"        => round($moyenne, 2),
            "max_valeur"     => $max_val,
            "apercu_max"     => $apercu_max,
            "dimensions_max" => $dimensions_max, // une ou plusieurs si ex æquo
        ];
    }

    public static function getMenuContent()
    {

        $menu = [];
        $menu['title'] = static::getTypeName(Session::getPluralNumber());
        $menu['shortcut'] = 'n';
        $menu['page'] = static::getSearchURL();
        $menu['icon'] = self::getIcon();
        $menu['config']['default'] = '/front/dropdown.php';


        $menu['options'] = [];
//        Bouton add
        if (static::canCreate()) {
            $menu['options']["concernedperson"]['links']['add'] = static::getFormURL(false);
        }

//        bouton rechercher
        $menu['options']["concernedperson"]['links']['search'] = static::getSearchURL(false);


//        bouton help
        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
        $menu['options']["concernedperson"]['links'][$image] = KnowbaseItem::getSearchURL(false) . '?contains="personne concernée"';

        echo "<script>
                        \$(document).ready(function () {
                            // Attendre que la page soit complètement chargée
                            \$('a[href^=\"/front/knowbaseitem.php?contains=\"]').attr('target', '_blank');
                           
                        });
                    </script>";


        if (count($_SESSION['glpiprofiles']) > 1) {
            $profile = new Profile();
            $name = 'Vue-Modele';
            $options = [
                'SELECT' => [
                    'id'
                ],
                'WHERE' => [
                    'name' => $name,
                ]
            ];

            global $DB;
            $req = $DB->request($profile->getTable(), $options);
            foreach ($req as $id => $row) {
                //if ($row = $req->next()) {
                $profile->getFromDB($row['id']);
                if (array_key_exists($profile->getID(), $_SESSION['glpiprofiles'])) {
                    $swap = $_SESSION['glpiactiveprofile']['id'] == $profile->getID();
                    $text = '<i class="fa fa-layer-group pointer" style="margin-right: 0.4em;"></i>' . __("Swap to model view", "dlteams");
                    $returnKey = array_key_first($_SESSION['glpiprofiles']) == $profile->getID() ? array_keys($_SESSION['glpiprofiles'])[1] : array_key_first($_SESSION['glpiprofiles']);
                    $prodif = $profile->getID();
                    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                    empty($swap) ? $text = "vue modèle" : $text = "vue modèle";
                    empty($swap) ? $val = $prodif : $val = $returnKey;
                    empty($swap) ? $checked = '' : $checked = 'checked';


                    $text_temp = "<div id='switchmodelcontainer' style='width:100%; display: flex;justify-content: center; margin-bottom: 1px; margin-right: 25px;'>
                                        <label class='form-check form-switch btn-xs  me-0 me-sm-1 px-1 py-1 mb-0 flex-column-reverse flex-sm-row'
                                            title='$text'>
                                         <input type='checkbox' class='form-check-input ms-0 me-1 mt-0' role='button'
                                                autocomplete='off'
                                                $checked
                                                onclick='window.location.href=`$server_url/front/central.php?newprofile=$val`'
                                                />
                                         <span class='form-check-label mb-1 mb-sm-0'>
                                            $text
                                         </span>
                                      </label></div>
                                      
                                      <script>
                                            var child = document.getElementById('switchmodelcontainer');
                                            var parent = child.parentNode;
                                            parent.style.border = 'none';
                                            parent.classList.remove('btn-outline-secondary');
                                        </script>
                            ";


                    $menu['options']["concernedperson"]['links'][$text_temp] = "/front/central.php?newprofile=$val";
                    break;


                }
            }

        }

        return $menu;
    }

    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }

    function prepareInputForAdd($input)
    {
        $input['users_id_creator'] = Session::getLoginUserID();
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input)
    {
        $input['users_id_lastupdater'] = Session::getLoginUserID();
        return parent::prepareInputForUpdate($input);
    }


    public function getSpecificMassiveActions($checkitem = null)
    {
        global $DB;

        $actions = parent::getSpecificMassiveActions($checkitem);
        $actions['Appliance' . MassiveAction::CLASS_ACTION_SEPARATOR . 'add_item'] =
            "<i class='fa-fw " . Appliance::getIcon() . "'></i>" . _x('button', 'Associate to an appliance');

        return $actions;
    }


    function cleanDBonPurge()
    {
        /*$rel = new PluginDlteamsRecord_MotifEnvoi();
        $rel->deleteByCriteria(['plugin_dlteams_concernedpersons_id' => $this->fields['id']]);*/
    }

    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'ranking',
            'name' => __("Classement"),
            'datatype' => 'number',
            'min' => 1,
            'max' => 10000,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true,
        ];

        $tab[] = [
            'id' => '3',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        if ($this->isEntityAssign()) {
            $tab[] = [
                'id' => '5',
                'table' => 'glpi_entities',
                'field' => 'completename',
                'name' => __("Entity"),
                'datatype' => 'dropdown',
                'massiveaction' => true,
            ];
        }

        $tab[] = [
            'id' => '6',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'datatype' => 'bool',
            'massiveaction' => false,
        ];

        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Content"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __("Creation date"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Last update"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '10',
            'table' => $this->getTable(),
            'field' => 'number',
            'name' => __("Nombre"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '11',
            'table' => $this->getTable(),
            'field' => 'newperyear',
            'name' => __("Entrants"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '12',
            'table' => $this->getTable(),
            'field' => 'deletedperyear',
            'name' => __("Sortants"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '101',
            'table' => 'glpi_plugin_dlteams_records_items',
            'field' => 'items_id1',
            'name' => _x('quantity', 'Données'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        $tab[] = [
            'id' => '108',
            'table' => 'glpi_plugin_dlteams_records_items',
            'field' => 'records_id',
            'name' => _x('quantity', 'Traitements'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        $tab[] = [
            'id' => '111',
            'table' => PluginDlteamsPolicieForm_Item::getTable(),
            'field' => 'items_id',
            'name' => _x('quantity', 'Jeux de données'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

//        $tab[] = [
//            'id'                 => '111',
//            'table'              => PluginDlteamsConcernedPerson_Item::getTable(),
//            'field'              => 'items_id',
//            'name'               => _x('quantity','Jeux données'),
//            'datatype'           => 'specific', //'itemlink',
//            'comments'           => true,
//            'nosort'             => false,
//            'additionalfields'   => ['itemtype'],
//            'joinparams'         => [
//                'linkfield' => 'concernedpersons_id',
//                'jointype'           => 'child',
//                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsPolicieForm::class."'",
//            ],
//            'forcegroupby'       => true,
//            'massiveaction'      => false,
//            'htmltext'           => true,
//            'showpolicies' => true
//            //'dlteams_activityname' => true,
//        ];
//
        return $tab;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();
        //add main tab for current object
        $this->addDefaultFormTab($ong)
            ->addImpactTab($ong, $options)
            ->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
            ->addStandardTab(PluginDlteamsPolicieForm_Item::class, $ong, $options)
            ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
//            ->addStandardTab('ManualLink', $ong, $options)
//            ->addStandardTab(PluginDlteamsProcessedData_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsMessage::class, $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('PluginDlteamsConcernedPerson_Item', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }

    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $export = $this->fields;
        return $export;
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $input['entities_id'] = $_POST['entities_id'];;
        $input['comment'] = str_replace(['\'', '"'], "", $input['comment']);
        $input['name'] = str_replace(['\'', '"'], "", $input['name']);
        $input['content'] = str_replace(['\'', '"'], "", $input['content']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }

    public function post_purgeItem()
    {


        $concernedpersons_item = new PluginDlteamsConcernedPerson_Item();
        $concernedpersons_item->deleteByCriteria([
            "concernedpersons_id" => $this->fields["id"],
            "itemtype" => "PluginDlteamsRecord",
            "itemtype1" => "PluginDlteamsProcessedData"
        ]);

        $record_item = new PluginDlteamsRecord_Item();
        $record_item->deleteByCriteria([
            "itemtype" => "PluginDlteamsConcernedPerson",
            "items_id" => $this->fields["id"],
//           "itemtype1" peut etre null
        ]);

        $processeddata_items = new PluginDlteamsProcessedData_Item();
        $processeddata_items->deleteByCriteria([
            "itemtype" => "PluginDlteamsRecord",
            "itemtype1" => "PluginDlteamsConcernedPerson",
            "items_id1" => $this->fields["id"],
        ]);
        parent::post_purgeItem(); // TODO: Change the autogenerated stub
    }

    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == 'PluginDlteamsConcernedPerson') {
                    /** @var PluginDlteamsConcernedPerson $item */
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {

                                Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    public function copy1($entity, $id, $item)
    {
        global $DB;
        $dbu = new DbUtils();
        $name = str_replace('"', '', addslashes($item->fields['name']));
        $entities_ori = $item->fields['entities_id'];
        $id_ori = $item->fields['id'];

        //var_dump($name);
        //var_dump($entities_ori);
        //var_dump($id_ori);

        $nb = $dbu->countElementsInTable(static::getTable(), ['name' => addslashes($name), 'entities_id' => $entity]);
        //var_dump($nb);

        $cp = new PluginDlteamsConcernedPerson();
        $cp->getFromDB($id);

        if ($nb <= 0) {
//            $DB->request("INSERT INTO " . static::getTable() . " (entities_id, is_recursive, date_mod, date_creation, name, content, comment, plugin_dlteams_rightmeasurecategories_id) SELECT '$entity', is_recursive, date_mod, date_creation, name, content, comment, 0 FROM " . static::getTable() . " WHERE id='$id'");
            $concernedperson = new PluginDlteamsConcernedPerson();
            $concernedperson->add([
                "name" => addslashes($cp->fields["name"] ?? ""),
                "content" => addslashes($cp->fields["content"] ?? ""),
                "comment" => addslashes($cp->fields["comment"] ?? ""),
                "is_recursive" => $cp->fields["is_recursive"],
                "ranking" => $cp->fields["ranking"],
                "entities_id" => $entity,
            ]);
            $newid = $concernedperson->fields["id"];

//           $DB->request("INSERT INTO " . PluginDlteamsRecord_Item::getTable() . " (records_id, items_id, itemtype, itemtype1, items_id1, comment) SELECT 'records_id', $newid, itemtype, itemtype1, items_id1, comment FROM " . PluginDlteamsRecord_Item::getTable() . " WHERE items_id='$id' AND itemtype='PluginDlteamsConcernedPerson'");
//           $DB->request("INSERT INTO " . PluginDlteamsConcernedPerson_Item::getTable() . " (concernedpersons_id, items_id, itemtype, items_id1, itemtype1, comment) SELECT $newid, items_id, itemtype, items_id1, itemtype1, comment FROM " . PluginDlteamsConcernedPerson_Item::getTable() . " WHERE itemtype='PluginDlteamsRecord' AND concernedpersons_id='$id'");
//           $DB->request("INSERT INTO " . PluginDlteamsProcessedData_Item::getTable() . " (processeddatas_id, items_id, itemtype, items_id1, itemtype1, comment) SELECT processeddatas_id, items_id, itemtype, items_id1, itemtype1, comment FROM " . PluginDlteamsProcessedData_Item::getTable() . " WHERE itemtype='PluginDlteamsRecord' AND itemtype1='PluginDlteamsConcernedPerson' AND items_id1='$id'");

            return true;
        } else {
            return false;
        }
    }


}
