<?php

use Glpi\RichText\UserMention;

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2023 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

/// Class KnowbaseItem_Comment
/// since version 9.2
class PluginDlteamsMessage extends CommonDBTM
{
    public static $rightname = 'plugin_dlteams_message';
    public $dohistory = true;
    protected $usenotepad = true;

    // TYPES
    const DEFAULT = 1;
    const TICKETTASKREPORT = 2; // Comptes rendu
    const TICKETTASKCONTROL = 3; // COntroles
    const SENDMAIL = 4; // rejected


    public static function getIcon()
    {
        return 'fas fa-comments';
    }

    public static function getMenuContent()
    {
        return parent::getMenuContent(); // TODO: Change the autogenerated stub
    }


    public function canAddItem($type)
    {
        return parent::canAddItem($type); // TODO: Change the autogenerated stub
    }

    public function canCreateItem()
    {
        return parent::canCreateItem(); // TODO: Change the autogenerated stub
    }

    public function canUpdateItem()
    {
        return parent::canUpdateItem(); // TODO: Change the autogenerated stub
    }

    public function canDeleteItem()
    {
        return parent::canDeleteItem(); // TODO: Change the autogenerated stub
    }

    public function canPurgeItem()
    {
        return true;
    }

    public function canViewItem()
    {
        return true;
    }

    public static function canCreate()
    {
        return true;
    }

    public static function canView()
    {
        return true;
    }

    public static function canUpdate()
    {
        return true;
    }

    public static function canDelete()
    {
        return true;
    }

    public static function canPurge()
    {
        return true;
    }

//    protected static $notable = true;


    public function __construct()
    {
        parent::forceTable("glpi_plugin_dlteams_messages");
    }

    public static function getTypeName($nb = 0)
    {
        return _n('Messages', 'Messages', $nb);
    }

    public static function getTable($classname = null)
    {
        return "glpi_plugin_dlteams_messages";
    }


    public static function getSpecificValueToDisplay($field, $values, array $options = [])
    {
        if (isset($options["searchopt"]["contentfield"]) && $options["searchopt"]["contentfield"]) {
            $content = $values["content"];

            $output = "";

            $output .= htmlspecialchars_decode($content);

            return $output;
        } elseif (isset($options["searchopt"]["objectfield"]) && $options["searchopt"]["objectfield"]) {
            $itemtype_str = $values["itemtype"];


            if (class_exists($itemtype_str))
                $itemtype = $itemtype_str::getTypeName();
            else
                $itemtype = $itemtype_str;

            return $itemtype;
        } elseif (isset($options["searchopt"]["dlteams_specific_itemtype"]) && $options["searchopt"]["dlteams_specific_itemtype"]) {
            /*            highlight_string("<?php\n\$data =\n" . var_export($values["id"], true) . ";\n?>");*/
//            die();
            $id = $values["id"];
            $if = new ITILFollowup();
            $if->getFromDB($id);


            $itemtype_str = $if->fields["itemtype"];
            if ($itemtype_str == PluginDlteamsTicketTask::class)
                $itemtype_str = TicketTask::class;
            $itemtype = new $itemtype_str();
            $output = "";


            $url = $itemtype::getFormURLWithID($if->fields["items_id"]);
            $output .= "<a href='$url' target='_blank'>" . $if->fields["items_id"] . "</a>";

            return $output;
        } elseif (isset($options["searchopt"]["objectfield_display_id"]) && $options["searchopt"]["objectfield_display_id"]) {
            /*                        highlight_string("<?php\n\$data =\n" . var_export($values["id"], true) . ";\n?>");*/
//            die();
            $id = $values["id"];
            $if = new ITILFollowup();
            $if->getFromDB($id);


            $itemtype_str = $if->fields["itemtype"];
            if ($itemtype_str == PluginDlteamsTicketTask::class)
                $itemtype_str = TicketTask::class;
            $itemtype = new $itemtype_str();
            $output = "";

            $url = $itemtype::getFormURLWithID($if->fields["items_id"]) . "&forcetab=PluginDlteamsMessage$1&#kbcomment" . $if->fields["id"];
            $output .= "<a href='$url' target='_blank'>" . $if->fields["id"] . "</a>";

            return $output;
        }
        parent::getSpecificValueToDisplay($field, $values, $options);
    }

    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item->getType()) {
            default:
                $nb = 0;
                if ($_SESSION['glpishow_count_on_tabs']) {

                    $where = [
                        'items_id' => $item->fields['id'],
                        'itemtype' => $item->getType()
                    ];

                    $nb = countElementsInTable(
                        ITILFollowup::getTable(),
                        $where
                    );


                    if ($where['itemtype'] == PluginDlteamsTicketTask::class) {
                        $tickettask = new TicketTask();
                        $tickettask->getFromDB($item->fields["id"]);

//           get planifications tasks
                        $planification_task_query = [
                            "FROM" => TicketTask::getTable(),
                            "WHERE" => [
                                "tickettasks_id" => $item->fields["id"]
                            ]
                        ];

                        global $DB;
                        $iterator = $DB->request($planification_task_query);

                        $planif_count_messages = 0;
                        foreach ($iterator as $pt) {
                            $planif_count_messages += count(self::getCommentsForKbItem($pt['id'], $where['itemtype'], null, true));
                        }
                        $nb += $planif_count_messages;
                    }

                    if ($where['itemtype'] == Ticket::class) {
                        $task_query = [
                            "FROM" => TicketTask::getTable(),
                            "WHERE" => [
                                "tickets_id" => $item->fields["id"]
                            ]
                        ];

                        global $DB;
                        $iterator = $DB->request($task_query);

                        $planif_count_messages = 0;
                        foreach ($iterator as $pt) {
                            $planif_count_messages += count(self::fetchComments($pt['id'], PluginDlteamsTicketTask::class));
                        }

//                tasks messages
                        $task_message_count = 0;
                        foreach ($iterator as $pt) {
                            $task_message_count += count(self::fetchComments($pt['id'], PluginDlteamsTicketTask::class));
                        }

                        $total = $nb + $task_message_count;
                        if ($task_message_count > 0)
                            $nb = "$nb + $task_message_count ($total)";
                    }


                }
                return [
//                    1 => self::createTabEntry("Messages", $nb)
                    1 => self::createTabEntry("Messages", count(self::fetchComments($item->fields["id"], $item->getType())))
                ];
                break;
        }
    }


    public static function showCentralList()
    {
        /** @var \DBmysql $DB */
        global $DB;

        $criteria = [
            'SELECT' => [PluginDlteamsMessage::getTable() . ".*"],
            'DISTINCT' => true,
            'FROM' => PluginDlteamsMessage::getTable(),
//            'WHERE'           => $WHERE + getEntitiesRestrictCriteria('glpi_tickets'),
            'ORDERBY' => PluginDlteamsMessage::getTable() . '.date_mod DESC'
        ];

        $iterator = $DB->request($criteria);
        $total_row_count = count($iterator);
        $displayed_row_count = min((int)$_SESSION['glpidisplay_count_on_home'], $total_row_count);
        $displayed_row_count = 10;

        if ($total_row_count > 0) {
            $options = [
                'criteria' => [],
                'reset' => 'reset',
            ];
            $forcetab = '';


            $main_header = "<a href=\"" . Ticket::getSearchURL() . "\">" .
                Html::makeTitle(__('Mes messages'), 0, 0) . "</a>";
            $twig_params = [
                'class' => 'table table-borderless table-striped table-hover card-table',
                'header_rows' => [
                    [
                        [
                            'colspan' => 4,
                            'content' => $main_header
                        ]
                    ]
                ],
                'rows' => []
            ];

            $i = 0;
            if ($displayed_row_count > 0) {
                $twig_params['header_rows'][] = [
                    [
                        'content' => __('ID'),
                        'style' => 'width: 5%'
                    ],
                    [
                        'content' => _n('Objet', 'Objets', 1),
                        'style' => 'width: 15%'
                    ],
                    [
                        'content' => _n('Elément', 'Eléments', 1),
                        'style' => 'width: 15%'
                    ],
                    [
                        'content' => _n('Contenu', 'Contenu', Session::getPluralNumber()),
                        'style' => 'width: 20%'
                    ],
//                    __('Description')
                ];
                foreach ($iterator as $data) {

                    if (class_exists($data["itemtype"])) {
                        $row = [
                            'values' => []
                        ];
                        $element = new  $data["itemtype"]();
                        $element->getFromDB($data["items_id"]);
                        $element = isset($element->fields["name"]) ? $element->fields["name"] : $element->fields["id"];
                        $content = substr(html_entity_decode($data["content"]), 0, 30) ?? "--";
                        $row['class'] = 'tab_bg_2';
                        $row['values'] = [
                            [
                                'colspan' => 6,
                                'content' => '<tr class="">
                                          <td colspan="1" class="" style=""><div class="priority_block" style="border-color: #ffcece"><span style="background: #ffcece"></span>&nbsp;ID : ' . $data["id"] . '</div></td>
                                          <td colspan="1" class="" style="">' . $data["itemtype"]::getTypeName() . '</td>
                                          <td colspan="1" class="" style="">' . $element . '</td>
                                          <td colspan="1" class="" style=""><a href="#">' . $content . '</a></td>
                     </tr>'
                            ]
                        ];

                        $twig_params['rows'][] = $row;

                        $i++;
                        if ($i == $displayed_row_count) {
                            break;
                        }
                    }
                }
                if (count($iterator) == 0) {
                    $row = [
                        'values' => []
                    ];

                    $row['class'] = 'tab_bg_2';
                    $row['values'] = [
                        [
                            'colspan' => 6,
                            'content' => "<i>" . __('No ticket in progress.') . "</i>"
                        ]
                    ];

                    $twig_params['rows'][] = $row;
                }
            }
            $output = \Glpi\Application\View\TemplateRenderer::getInstance()->render('components/table.html.twig', $twig_params);

            echo $output;

        }
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($tabnum) {
            case 1:
                self::showForItemV2($item);
                break;
        }
        return true;
    }

    public function showForm($ID, array $options = [])
    {
        self::showForItemV2($this);
    }



    public static function showForItemV2(CommonDBTM $item, $withtemplate = 0)
    {
        $itemId   = $item->fields['id'];
        $itemType = $item->getType();

        // Contexte Message -> vue utilisateur
        $items_id = $item->fields["id"];
        $itemtype = $item->getType();

        if ($item->getType() == PluginDlteamsMessage::class) {
            $itemId   = Session::getLoginUserID();
            $itemType = User::class;

            $items_id = Session::getLoginUserID();
            $itemtype = User::class;
        }

        echo "<br/>";

        // Récupération des commentaires
        $comments = self::fetchComments($itemId, $itemType);
        self::sortCommentsByDate($comments);

        // Cache utilisateurs
        $userCache = [];

        echo "<div id='dlteams-chat-container' class='dlteams-chat-container'>";
        echo "  <div class='dlteams-chat-messages' id='dlteamsChatMessages'>";

        if (!empty($comments)) {
            foreach ($comments as &$root) {
                if (is_array($root) && !isset($root['_root_id'])) {
                    $root['_root_id'] = $root['id'];
                }
            }
            unset($root);

            foreach ($comments as $root) {
                $rootId    = (int)$root['id'];
                $objetStr  = $root["itemtype"];
                $objetName = $objetStr::getTypeName();
                $objetId   = $root["items_id"];
                $convname  = !empty($root["conversationname"]) ? (" → " . $root["conversationname"]) : "";

                // Linéariser l’arbre en timeline chrono
                $timeline = [];
                $stack = [$root];
                while ($stack) {
                    $node = array_shift($stack);
                    $timeline[] = $node;
                    if (!empty($node['answers']) && is_array($node['answers'])) {
                        foreach ($node['answers'] as $ans) {
                            $stack[] = $ans;
                        }
                    }
                }
                usort($timeline, function ($a, $b) {
                    return strtotime($a['date_creation'] ?? '0000-00-00 00:00:00')
                        <=> strtotime($b['date_creation'] ?? '0000-00-00 00:00:00');
                });
                $msgCount = count($timeline);

                // Tooltip d’aide sur le compteur
                $apply_to_count = "convcount_" . $rootId . "_" . mt_rand();
                echo Html::showToolTip(
                    __('Nombre total de messages dans cette conversation'),
                    ['display' => false, 'applyto' => $apply_to_count, 'title' => __('Aide')]
                );

                // En-tête conversation (collapse + badges)
                echo "<div class='dlteams-conversation' data-conv-id='{$rootId}'>";
                echo "  <div class='dlteams-conv-header'>";
                echo "      <button class='conv-toggle' data-target='conv-body-{$rootId}' aria-expanded='true'><i class='fa fa-chevron-down'></i></button>";
                echo "      <div class='conv-title'>
                           <span class='conv-label'>Conversation {$rootId} ({$objetName} {$objetId})</span>
                           <span class='conv-sub'>{$convname}</span>
                        </div>";
                echo "      <div class='conv-actions'>
                           <span id='{$apply_to_count}' class='conv-count-badge'>{$msgCount}</span>
                           <span class='conv-unread badge' id='conv-unread-{$rootId}' style='display:none'>0</span>
                           <button class='conv-markread btn btn-link btn-sm' data-conv='{$rootId}' title='" . __('Marquer comme lu') . "'>
                               <i class='fa fa-check-circle'></i>
                           </button>
                        </div>";
                echo "  </div>";

                echo "  <div class='dlteams-conv-body' id='conv-body-{$rootId}'>";

                // Rendu des messages
                foreach ($timeline as $msg) {
                    self::renderComment($msg, $userCache, $itemType, $rootId);
                }

                echo "  </div>"; // conv-body
                echo "</div>";   // conversation
            }
        } else {
            echo "<div class='dlteams-no-messages'>" . __('No messages yet.') . "</div>";
        }

        echo "  </div>"; // dlteams-chat-messages

        self::addChatStyles();
        self::addChatScripts();

        echo "</div>"; // dlteams-chat-container

        echo self::renderMessageForm($items_id, $itemtype);
    }



    private static function renderComment(array $comment, array &$userCache, string $itemType, int $rootId)
    {
        // Cache user
        if (!isset($userCache[$comment['users_id']])) {
            $user = new User();
            $user->getFromDB($comment['users_id']);
            $userCache[$comment['users_id']] = [
                'name'     => htmlspecialchars($user->fields["firstname"] . " " . $user->fields["realname"]),
                'link'     => User::getFormURLWithID($comment["users_id"]),
                'initials' => $user->getUserInitials(),
                'bg'       => $user->getUserInitialsBgColor(),
            ];
        }

        $isSentByUser  = (Session::getLoginUserID() == $comment['users_id']);
        $avatar        = $userCache[$comment['users_id']]["initials"];
        $avatarBg      = $userCache[$comment['users_id']]["bg"];
        $messageClass  = $isSentByUser ? 'dlteams-sent' : 'dlteams-received';
        $contentClass  = $isSentByUser ? 'dlteams-sent-content' : 'dlteams-received-content';
        $authorLink    = "<a href='{$userCache[$comment['users_id']]['link']}' target='_blank'>{$userCache[$comment['users_id']]['name']}</a>";

        $messageId     = (int)$comment['id'];
        $itemtype      = $comment["itemtype"];
        $items_id      = $comment["items_id"];

        // Dates
        $createdAbs    = date('d-m-Y H:i', strtotime($comment['date_creation']));
        $createdRel    = Html::timestampToRelativeStr($comment['date_creation']);
        $edited        = (!empty($comment['date_mod']) && $comment['date_mod'] !== $comment['date_creation']);
        $editedRel     = $edited ? Html::timestampToRelativeStr($comment['date_mod']) : '';
        $createdIso    = date('c', strtotime($comment['date_creation']));
        $formatted_datetime_creation = date('d-m-Y H:i', strtotime($comment['date_creation']));
        $formatted_datetime_mod = $comment['date_mod']?date('d-m-Y H:i', strtotime($comment['date_mod'])):"--";

        // Extrait parent
        $parentExcerpt = '';
        if (!empty($comment['parent_comment_id'])) {
            $pc = new ITILFollowup();
            if ($pc->getFromDB($comment['parent_comment_id'])) {
                $parentExcerpt = static::truncateHtmlContent(htmlspecialchars_decode($pc->fields['content']), 100);
            }
        }
        $tagBlock = !empty($comment['tag']) ? htmlspecialchars_decode($comment['tag']) : '';

        // Style autre itemtype
        $stylesBg = ($comment["itemtype"] != $itemType) ? "background-color: #eefcfe" : "";

        // ---- Vues (lu/non lu) & avatars empilés ----
        global $DB;
        $views_query = [
            "FROM"  => PluginDlteamsITILFollowup_View::getTable(),
            "WHERE" => ["itilfollowups_id" => $messageId]
        ];
        $iteratorows = $DB->request($views_query);

        $total      = count($iteratorows);
        $maxVisible = 3;
        $i          = 0;

        $rand_apply = mt_rand();
        $apply_to   = "views" . $rand_apply;

        // Contenu du tooltip (liste des viewers)
        $viewersHtml = "";
        $isReadByMe  = false;
        foreach ($iteratorows as $iteratorow) {
            $u = new User();
            $u->getFromDB($iteratorow["items_id"]);
            if ($iteratorow["items_id"] == Session::getLoginUserID()) {
                $isReadByMe = true;
            }
            $initials = $u->getUserInitials();
            $bg_color = $u->getUserInitialsBgColor();
            $tsRel    = Html::timestampToRelativeStr($iteratorow['date_creation']);
            $tsAbs    = date('d-m-Y H:i', strtotime($iteratorow['date_creation']));

            $viewersHtml .= "<div style='display:flex;gap:.3rem;align-items:center;margin:.15rem 0'>
                           <div class='dlteams-message-avatar' style=\"width:20px;height:20px;font-size:9px;line-height:20px;background-color:{$bg_color}\">{$initials}</div>
                           <span>" . $u->fields["firstname"] . " " . $u->fields["realname"] . "</span>
                           <span title='{$tsAbs}' style='color:#001f5d;font-weight:400;font-size:.6rem'>
                               &nbsp;&nbsp;<i class='far fa-clock me-1'></i> {$tsRel}
                           </span>
                         </div>";
        }

        echo Html::showToolTip(
            $viewersHtml ?: __('Aucune vue enregistrée.'),
            [
                'display'       => false,
                'awesome-class' => '',
                'autoclose'     => false,
                'applyto'       => $apply_to,
                'title'         => __('Vues')
            ]
        );

        // Classe non-lu si je n’ai pas vu ce message
        $unreadClass = $isReadByMe ? '' : 'is-unread';

        // ---- Rendu du message ----
        echo "<div class='dlteams-message {$messageClass} {$unreadClass}'
           id='kbcomment{$messageId}'
           data-message-id='{$messageId}'
           data-user-id='{$comment['users_id']}'
           data-created='{$createdIso}'
           data-conv-id='{$rootId}'>";

        // Avatar
        echo "  <div class='dlteams-message-avatar' style='background-color: {$avatarBg}'>{$avatar}</div>";

        // Contenu
        echo "  <div class='dlteams-message-content {$contentClass}' style='{$stylesBg}'>";

        // ENTÊTE UNIQUE : [btn collapse]  #id  Auteur | relatif   …… (lecteurs à droite)
        $collapseId = "msgcollapse_" . $messageId;
        $help_apply = "msgidhelp_" . $messageId . "_" . mt_rand();
        echo Html::showToolTip(__('Id du message'), ['display'=>false,'applyto'=>$help_apply,'title'=>__('Aide')]);

        echo "    <div class='msg-headline'>
                 <div class='msg-left'>
                   <button class='msg-collapse' data-msg='{$messageId}' id='{$collapseId}' title='" . __('Afficher/Masquer le contenu') . "'>
                      <i class='fa fa-compress'></i>
                   </button>
                   <span id='{$help_apply}' class='msg-id'>#{$messageId}</span>
                   <span class='msg-meta'>{$authorLink} | <span title='$formatted_datetime_creation' data-bs-toggle='tooltip' data-bs-placement='bottom'>{$createdRel}</span>" .
            ($edited ? " <span title='$formatted_datetime_mod' data-bs-toggle='tooltip' data-bs-placement='bottom' class='edited'>(" . __('modifié') . " {$editedRel})</span>" : "") .
            "</span>
                 </div>
                 <div class='msg-views' id='{$apply_to}' title='" . __('Voir les lecteurs') . "'>";

        foreach ($iteratorows as $iteratorow) {
            if ($i < $maxVisible) {
                $u = new User();
                $u->getFromDB($iteratorow["items_id"]);
                $initials = $u->getUserInitials();
                $bg_color = $u->getUserInitialsBgColor();
                $margin   = ($i === 0) ? '0' : '-12px';
                $zindex   = $maxVisible + $i;
                echo "<div class='dlteams-message-avatar' style='width:20px;height:20px;font-size:9px;line-height:20px;background-color:{$bg_color};margin-left:{$margin};z-index:{$zindex}'>{$initials}</div>";
            } elseif ($i === $maxVisible) {
                $remaining = $total - $maxVisible;
                echo "<div class='dlteams-message-avatar dlteams-avatar-more' style='width:20px;height:20px;font-size:9px;line-height:20px;margin-left:-12px;z-index:" . ($maxVisible+$i) . "'>+{$remaining}</div>";
                break;
            }
            $i++;
        }
        echo "     </div>
          </div>";

        // Références parent/tag
        if ($parentExcerpt) {
            echo "  <blockquote class='dlteams-message-parent' onclick='scrollToMessage(\"kbcomment{$comment['parent_comment_id']}\")'>
               <div class='parent-content'>#{$comment['parent_comment_id']} {$parentExcerpt}</div>
             </blockquote>";
        }
        if ($tagBlock) {
            echo "  <blockquote class='dlteams-message-parent tag'>
               <div class='parent-content'>{$tagBlock}</div>
             </blockquote>";
        }

        // Texte du message (collapsible)
        echo "      <span class='message-text' id='message-text-{$messageId}'>" . stripslashes(htmlspecialchars_decode($comment['content'])) . "</span>";

        // Chips de réactions (remplis côté JS) — débordent de la bulle (position absolute via CSS)
        echo "      <div class='msg-reactions' data-msg-id='{$messageId}'></div>";

        echo "  </div>"; // content

        // Actions — bouton emoji masqué par défaut, visible au survol de .dlteams-message
        echo "  <div class='dlteams-message-actions'>
          <span class='action reaction' title='" . __('Réagir') . "'>
            <i onclick='openReactionPalette({$messageId}, this)' class='fa fa-smile'></i>
          </span>
          <span class='action' title='" . __('Transférer') . "'>
            <i onclick='forwardMessage({$messageId}, \"{$itemtype}\", {$items_id})' class='fa fa-arrow-right'></i>
          </span>";
        if ($isSentByUser) {
            echo "<span class='action' title='" . __('Éditer') . "'>
            <i onclick='editMessage({$messageId}, \"{$itemtype}\", {$items_id})' class='fa fa-edit'></i>
          </span>";
        }
        echo "    <span class='action' title='" . __('Répondre') . "'>
            <i onclick='answerMessage({$messageId}, \"{$itemtype}\", {$items_id})' class='fa fa-reply'></i>
          </span>
        </div>";

        echo "</div>"; // message
    }




    private static function addChatStyles()
    {
        echo "<style>
/* Conteneur */
.dlteams-chat-container{width:100%;height:65vh;border:1px solid #e6e8ef;border-radius:12px;display:flex;flex-direction:column;background:#fafbff;overflow:hidden}
.dlteams-chat-messages{flex-grow:1;padding:8px 12px;overflow-y:auto;display:flex;flex-direction:column;gap:.6rem}

/* Conversations */
.dlteams-conversation{background:#fff;border:1px solid #edf0f6;border-radius:10px;box-shadow:0 1px 2px rgba(16,24,40,.04)}
.dlteams-conv-header{display:flex;align-items:center;gap:.5rem;padding:.55rem .8rem;border-bottom:1px solid #f0f2f7}
.dlteams-conv-header .conv-toggle{border:none;background:transparent;cursor:pointer}
.dlteams-conv-header .conv-title{display:flex;gap:.4rem;align-items:baseline;flex:1;min-width:0}
.dlteams-conv-header .conv-label{font-weight:600}
.dlteams-conv-header .conv-sub{color:#6c727f;font-size:.85rem;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
.conv-actions{display:flex;align-items:center;gap:.5rem}
.conv-count-badge{background:#e9eefc;color:#1b3bbb;border-radius:10px;padding:2px 6px;font-size:.72rem;border:1px solid #cfd9ff}
.conv-unread{background:#1f6feb;color:#fff;border-radius:10px;padding:2px 6px;font-size:.72rem}

/* Corps conv */
.dlteams-conv-body{padding:.6rem .8rem; background-color: gainsboro;}

/* Message */
.dlteams-message{display:flex;gap:.7rem;margin:1.0rem 0 .9rem 0;align-items:flex-end;position:relative}
.dlteams-message.is-unread .dlteams-message-content{box-shadow:0 0 0 2px rgba(31,111,239,.22);background:#f5f9ff}
.dlteams-message-avatar{width:34px;height:34px;border-radius:50%;display:flex;align-items:center;justify-content:center;color:#fff;font-size:12px;font-weight:700;flex:0 0 34px}
.dlteams-message-content{max-width:72%;padding:10px 12px 18px 12px;border-radius:14px;background:#fff;border:1px solid #e6e8ef;position:relative;overflow:visible}
.dlteams-message.dlteams-sent{justify-content:flex-end}
.dlteams-message.dlteams-sent .dlteams-message-avatar{order:2}
.dlteams-message.dlteams-sent .dlteams-message-content{order:1;border-radius:14px 14px 0 14px}
.dlteams-message.dlteams-received{justify-content:flex-start}
.dlteams-sent-content{background:#eff4ff;border-color:#c9d3ff}
.dlteams-received-content{background:#ffffff;border-color:#e6e8ef}

/* Références parent/tag */
.dlteams-message-parent{border-left:3px solid #0b5fff;margin:.25rem 0 .5rem 0;padding:.25rem .5rem;background:#f6f9ff;cursor:pointer}
.dlteams-message-parent.tag{border-left-color:#8a2be2;background:#f8f4ff}

.message-text{white-space:pre-wrap;word-wrap:break-word}

/* Entête unique */
.msg-headline{display:flex;align-items:center;gap:.6rem;margin-bottom:.25rem}
.msg-left{display:flex;align-items:center;gap:.5rem;flex:1;min-width:0}
.msg-collapse{border:none;background:transparent;cursor:pointer;color:#6b7280}
.msg-collapse:hover{color:#111827}
.msg-id{font-size:.8rem;color:#6b7280}
.msg-meta{font-size:.85rem;color:#4b5563}
.msg-views{display:flex;align-items:center;margin-left:auto}
.dlteams-avatar-more{background:#666;color:#fff;font-weight:700;border-radius:50%;text-align:center}

/* Collapse texte */
.dlteams-message-content.is-collapsed .message-text{display:block;max-height:2.8rem;overflow:hidden;position:relative}
.dlteams-message-content.is-collapsed .message-text:after{
  content:'';position:absolute;bottom:0;right:0;left:0;height:1.2rem;
  background:linear-gradient(180deg, rgba(255,255,255,0), #fff 60%)
}

/* Actions (icônes à droite) */
.dlteams-message-actions{display:flex;flex-direction:column;gap:.35rem;margin:0 .25rem;position:relative}
.dlteams-message-actions .action{cursor:pointer;color:#6b7280;font-size:.95rem}
.dlteams-message-actions .action:hover{color:#111827}
/* Bouton emoji: masqué par défaut, visible au survol de toute la ligne message */
.dlteams-message .dlteams-message-actions .action.reaction{opacity:0;pointer-events:none;transition:opacity .15s ease}
.dlteams-message:hover .dlteams-message-actions .action.reaction{opacity:1;pointer-events:auto}

/* Chips de réactions – débordent de la bulle */
.msg-reactions{position:absolute;bottom:-12px;display:flex;gap:.25rem;flex-wrap:wrap;z-index:3}
.dlteams-message.dlteams-sent .msg-reactions{right:10px}
.dlteams-message.dlteams-received .msg-reactions{left:10px}
.msg-reactions:empty{display:none}
.rx-chip{border:1px solid #e2e7f2;background:#fff;color:#333;border-radius:14px;padding:2px 8px;cursor:pointer;font-size:.8rem;line-height:1;box-shadow:0 2px 6px rgba(18,28,45,.08)}
.rx-chip[aria-pressed='true']{border-color:#5b8cff;background:#eef3ff}

/* Palette de réactions (au clic sur bouton emoji) */
.rx-palette{position:fixed;display:flex;gap:.25rem;background:#fff;border:1px solid #e2e7f2;border-radius:10px;padding:.25rem .35rem;
  box-shadow:0 10px 20px rgba(18,28,45,.16);z-index:9999}
.rx-palette .rx-em{border:1px solid #e2e7f2;background:#fff;border-radius:10px;padding:2px 6px;cursor:pointer;font-size:1rem;line-height:1}
.rx-palette .rx-em:focus{outline:none;border-color:#c2c9df}

/* Tooltip */
.rx-who{position:fixed;min-width:190px;max-width:280px;background:#fff;border:1px solid #e2e7f2;border-radius:10px;padding:.35rem .5rem;
  box-shadow:0 10px 20px rgba(18,28,45,.16);z-index:9999}
.rx-who-row{display:flex;align-items:center;gap:.4rem;margin:.2rem 0}
.rx-who-row .av{width:20px;height:20px;border-radius:50%;display:flex;align-items:center;justify-content:center;color:#fff;font-size:9px;font-weight:700}


/* No messages */
.dlteams-no-messages{text-align:center;color:#9aa1af;margin-top:12px}

/* Input */
.dlteams-toolbar{display:flex;gap:.5rem;justify-content:flex-end;margin:.25rem 0}
#chat-input-container .dlteams-chat-footer{padding:.5rem;background:#f7f8fc;border-top:1px solid #eef0f6;border-radius:8px}
#chat-input-container .input-row{display:flex;gap:.5rem;align-items:center}
#chat-input-container .input-col{flex:1}
.send-btn{margin-left:.25rem;background:#0b5fff;color:#fff;border:none;border-radius:18px;width:36px;height:36px;display:flex;align-items:center;justify-content:center}

/* Divers */
.highlighted{animation:hl 1.6s ease-in-out 1}
@keyframes hl{0%{background:#fffbcc}100%{background:transparent}}
.tox.tox-tinymce{width:100%!important}
.edited{color:#8b8fa3}
</style>";
}




    /**************************************************
     * SCRIPTS (collapse + unread via LocalStorage)
     **************************************************/
    private static function addChatScripts()
    {
        $currentUser = (int)Session::getLoginUserID();
        ?>
        <script>
            (function(){
                "use strict";

                const CURRENT_USER_ID = <?php echo json_encode($currentUser); ?>;

                // ---------- Navigation / focus ----------
                function openConversationForMessage(messageEl){
                    const conv = messageEl.closest('.dlteams-conversation');
                    if(!conv) return;
                    const body   = conv.querySelector('.dlteams-conv-body');
                    const toggle = conv.querySelector('.conv-toggle');
                    if(body && toggle && body.style.display === 'none'){
                        body.style.display = 'block';
                        toggle.setAttribute('aria-expanded','true');
                        toggle.innerHTML = '<i class="fa fa-chevron-down"></i>';
                        const convId = conv.dataset.convId;
                        if(convId) localStorage.setItem('dlteams_conv_collapsed_'+convId,'0');
                    }
                }
                function scrollToMessageDomId(domId){
                    const el = document.getElementById(domId);
                    if(!el) return;
                    openConversationForMessage(el);
                    el.scrollIntoView({behavior:'smooth', block:'center'});
                    el.classList.add('highlighted');
                    setTimeout(()=>el.classList.remove('highlighted'), 1600);
                }
                window.scrollToMessage = function(messageId){ scrollToMessageDomId(messageId); };

                // ---------- Collapse conversations ----------
                function lsKeyCollapsed(convId){ return `dlteams_conv_collapsed_${convId}`; }
                function getCollapsed(convId){ return localStorage.getItem(lsKeyCollapsed(convId)) === '1'; }
                function setCollapsed(convId, val){ localStorage.setItem(lsKeyCollapsed(convId), val ? '1' : '0'); }
                function applyInitialCollapse(conv){
                    const convId = conv.dataset.convId;
                    const body   = conv.querySelector('.dlteams-conv-body');
                    const toggle = conv.querySelector('.conv-toggle');
                    if(!body || !toggle || !convId) return;
                    const collapsed = getCollapsed(convId);
                    if(collapsed){
                        body.style.display = 'none';
                        toggle.setAttribute('aria-expanded','false');
                        toggle.innerHTML = '<i class="fa fa-chevron-right"></i>';
                    } else {
                        body.style.display = 'block';
                        toggle.setAttribute('aria-expanded','true');
                        toggle.innerHTML = '<i class="fa fa-chevron-down"></i>';
                    }
                }
                function attachConversationHandlers(conv){
                    const convId = conv.dataset.convId;
                    const body   = conv.querySelector('.dlteams-conv-body');
                    const toggle = conv.querySelector('.conv-toggle');
                    const markBtn= conv.querySelector('.conv-markread');

                    if(toggle){
                        toggle.addEventListener('click', ()=>{
                            const expanded = toggle.getAttribute('aria-expanded') === 'true';
                            if(expanded){
                                if(body) body.style.display = 'none';
                                toggle.setAttribute('aria-expanded','false');
                                toggle.innerHTML = '<i class="fa fa-chevron-right"></i>';
                                if(convId) setCollapsed(convId, true);
                            } else {
                                if(body) body.style.display = 'block';
                                toggle.setAttribute('aria-expanded','true');
                                toggle.innerHTML = '<i class="fa fa-chevron-down"></i>';
                                if(convId) setCollapsed(convId, false);
                            }
                        });
                    }

                    if(markBtn && body){
                        markBtn.addEventListener('click', ()=>{
                            body.querySelectorAll('.dlteams-message.is-unread').forEach(m=>m.classList.remove('is-unread'));
                            const badge = conv.querySelector('.conv-unread');
                            if(badge) badge.style.display = 'none';
                        });
                    }
                }

                // ---------- Collapse messages ----------
                function msgLsKey(id){ return `dlteams_msg_collapsed_${id}`; }
                function applyMsgCollapsedState(msgEl){
                    const id  = msgEl.dataset.messageId;
                    if(!id) return;
                    const isCollapsed = (localStorage.getItem(msgLsKey(id)) === '1');
                    const content = msgEl.querySelector('.dlteams-message-content');
                    const icon    = msgEl.querySelector('.msg-collapse i');
                    if(content){ content.classList.toggle('is-collapsed', isCollapsed); }
                    if(icon){ icon.className = isCollapsed ? 'fa fa-expand' : 'fa fa-compress'; }
                }
                function toggleMsgCollapse(msgEl){
                    const id  = msgEl.dataset.messageId;
                    if(!id) return;
                    const key = msgLsKey(id);
                    const content = msgEl.querySelector('.dlteams-message-content');
                    const icon    = msgEl.querySelector('.msg-collapse i');
                    if(!content) return;
                    const willCollapse = !content.classList.contains('is-collapsed');
                    content.classList.toggle('is-collapsed', willCollapse);
                    localStorage.setItem(key, willCollapse ? '1' : '0');
                    if(icon){ icon.className = willCollapse ? 'fa fa-expand' : 'fa fa-compress'; }
                }

                // ---------- Unread badges ----------
                function updateUnreadBadges(){
                    document.querySelectorAll('.dlteams-conversation').forEach(conv=>{
                        const body  = conv.querySelector('.dlteams-conv-body');
                        const badge = conv.querySelector('.conv-unread');
                        if(!body || !badge) return;
                        const unread = body.querySelectorAll('.dlteams-message.is-unread').length;
                        if(unread > 0){
                            badge.textContent = unread.toString();
                            badge.style.display = 'inline-block';
                        } else {
                            badge.style.display = 'none';
                        }
                    });
                }
                window.dlteamsUpdateUnreadBadges = updateUnreadBadges;

                function rxGetActiveChip(container){
                    return container.querySelector('.rx-chip[aria-pressed="true"]');
                }

                function rxRemoveChipImmediate(chip){
                    const cont = chip?.parentElement;
                    if (!cont) return;
                    chip.remove();
                    const left = cont.querySelectorAll('.rx-chip').length;
                    cont.style.display = left ? 'flex' : 'none';
                }

                function rxRefreshOne(msgId, container){
                    rxApiList([msgId]).then(res=>{
                        if(res && res.ok){
                            rxRenderChips(container, msgId, res.data[msgId] || []);
                        }
                    });
                }

                /* Réaction exclusive : remplace une éventuelle réaction existante par la nouvelle, sans flash “0” */
                function rxSetExclusive(msgId, emoji, container){
                    const oldActive = rxGetActiveChip(container);
                    const target    = container.querySelector(`.rx-chip[data-emoji="${emoji}"]`);

                    // 1) retirer l’ancienne réaction (si différente) — sans montrer 0
                    if (oldActive && oldActive !== target) {
                        const cntEl = oldActive.querySelector('.rx-count');
                        const oldCnt = parseInt(cntEl.textContent || '1', 10);
                        if (oldCnt <= 1) {
                            rxRemoveChipImmediate(oldActive);
                        } else {
                            cntEl.textContent = String(oldCnt - 1);
                            oldActive.setAttribute('aria-pressed','false');
                            oldActive.style.border = '1px solid #e2e7f2';
                            oldActive.style.background = '#fff';
                        }
                    }

                    // 2) activer / créer la nouvelle puce
                    let chip = target;
                    if (!chip) {
                        chip = rxBuildChip(String(msgId), emoji, 1, true); // on crée directement à 1 pour éviter “0”
                        const plus = container.querySelector('.rx-plus');
                        plus ? container.insertBefore(chip, plus) : container.appendChild(chip);
                    } else {
                        const cntEl = chip.querySelector('.rx-count');
                        const cur = parseInt(cntEl.textContent || '0', 10);
                        cntEl.textContent = String(cur + 1);
                        chip.setAttribute('aria-pressed','true');
                        chip.style.border = '1px solid #5b8cff';
                        chip.style.background = '#eef3ff';
                    }

                    // 3) serveur – exclusif (si ton endpoint l’accepte) puis refresh sûr
                    $.ajax({
                        url: '/marketplace/dlteams/ajax/reaction.toggle.php',
                        type: 'POST',
                        dataType: 'json',
                        data: { itilfollowups_id: msgId, emoji_key: emoji, exclusive: 1 }
                    }).always(()=> rxRefreshOne(msgId, container));
                }

                // ---------- Actions existantes ----------
                window.answerMessage = function (messageId, itemtype, items_id) {
                    const chatInputContainer    = document.getElementById('chat-input-container');
                    const newConversationButton = document.getElementById('newConversationButton');
                    const hideInputButton       = document.getElementById('hideInputButton');
                    const mailablecontent       = document.getElementById('mailablecontent');

                    if(chatInputContainer) chatInputContainer.style.display = 'block';
                    if(newConversationButton) newConversationButton.style.display = 'none';
                    if(hideInputButton) hideInputButton.style.display = 'block';
                    if(mailablecontent) mailablecontent.style.display = 'none';

                    $.ajax({
                        url: '/marketplace/dlteams/ajax/getMessageContent.php',
                        type: 'POST',
                        data: {id: messageId},
                        success: function (response) {
                            const data = JSON.parse(response);
                            const replyPlaceholder = document.getElementById('reply-content-placeholder');
                            if(replyPlaceholder){
                                replyPlaceholder.style.display = 'flex';
                                const quote = replyPlaceholder.querySelector('.reply-quote');
                                if(quote){
                                    quote.innerHTML = `<strong>${data.author?.name || "Auteur inconnu"} :</strong> ${data.data_cut || ""}`;
                                }
                            }
                            let replyInput = document.querySelector('#messageform input[name="reply_to"]');
                            if (!replyInput) {
                                replyInput = document.createElement('input');
                                replyInput.type = 'hidden';
                                replyInput.name = 'reply_to';
                                const form = document.querySelector('#messageform');
                                if(form) form.appendChild(replyInput);
                            }
                            replyInput.value = messageId;
                        }
                    });
                };

                window.forwardMessage = function (messageId, itemtype, items_id) {
                    glpi_ajax_dialog({
                        dialogclass: 'modal-lg',
                        title: <?php echo json_encode(__('Déplacer un message')); ?>,
                        url: '/marketplace/dlteams/ajax/getForwardMessageForm.php',
                        params: { action: 'display_embed_form', id: messageId, itemtype, items_id }
                    });
                };

                window.editMessage = function (messageId, itemtype, items_id) {
                    const chatInputContainer    = document.getElementById('chat-input-container');
                    const newConversationButton = document.getElementById('newConversationButton');
                    const hideInputButton       = document.getElementById('hideInputButton');
                    const mailablecontent       = document.getElementById('mailablecontent');

                    if(chatInputContainer) chatInputContainer.style.display = 'block';
                    if(newConversationButton) newConversationButton.style.display = 'none';
                    if(hideInputButton) hideInputButton.style.display = 'block';
                    if(mailablecontent) mailablecontent.style.display = 'none';

                    $.ajax({
                        url: '/marketplace/dlteams/ajax/getMessageContent.php',
                        type: 'POST',
                        data: {id: messageId},
                        success: function (response) {
                            const data = JSON.parse(response);
                            if(window.tinymce && tinymce.get("dlteamsMessageInput")){
                                tinymce.get("dlteamsMessageInput").setContent(data.data);
                            }
                            let editInput = document.querySelector('#messageform input[name="edit"]');
                            if (!editInput) {
                                editInput = document.createElement('input');
                                editInput.type = 'hidden';
                                editInput.name = 'edit';
                                const form = document.querySelector('#messageform');
                                if(form) form.appendChild(editInput);
                            }
                            editInput.value = messageId;

                            const replyPlaceholder = document.getElementById('reply-content-placeholder');
                            if(replyPlaceholder){
                                replyPlaceholder.style.display = 'block';
                                const quote = replyPlaceholder.querySelector('.reply-quote');
                                if(quote){
                                    quote.innerText = <?php echo json_encode(__('Vous éditez un message.')); ?>;
                                }
                            }
                        }
                    });
                };

                window.exitMode = function () {
                    const chatInputContainer    = document.getElementById('chat-input-container');
                    const newConversationButton = document.getElementById('newConversationButton');
                    const hideInputButton       = document.getElementById('hideInputButton');

                    if(chatInputContainer) chatInputContainer.style.display = 'none';
                    if(newConversationButton) newConversationButton.style.display = 'block';
                    if(hideInputButton) hideInputButton.style.display = 'none';

                    if(window.tinymce && tinymce.get("dlteamsMessageInput")){
                        tinymce.get("dlteamsMessageInput").setContent("");
                    }

                    const replyInput = document.querySelector('#messageform input[name="reply_to"]');
                    const editInput  = document.querySelector('#messageform input[name="edit"]');
                    if (replyInput) replyInput.remove();
                    if (editInput)  editInput.remove();

                    const replyPlaceholder = document.getElementById('reply-content-placeholder');
                    if(replyPlaceholder){
                        replyPlaceholder.style.display = 'none';
                    }
                };

                // ======================================================
                //  RÉACTIONS – set pro + remplacement (1 seule réaction)
                // ======================================================
                const RX_ALLOWED = ['✅','👍','👏','😮','😢','🙂'];

                function rxApiList(messageIds){
                    return $.ajax({
                        url: '/marketplace/dlteams/ajax/reaction.list.php',
                        type: 'POST',
                        dataType: 'json',
                        data: { message_ids: messageIds }
                    });
                }
                function rxApiToggle(itilfollowups_id, emoji){
                    return $.ajax({
                        url: '/marketplace/dlteams/ajax/reaction.toggle.php',
                        type: 'POST',
                        dataType: 'json',
                        data: { itilfollowups_id, emoji_key: emoji }
                    });
                }
                function rxApiWho(itilfollowups_id, emoji){
                    return $.ajax({
                        url: '/marketplace/dlteams/ajax/reaction.who.php',
                        type: 'POST',
                        dataType: 'json',
                        data: { itilfollowups_id, emoji_key: emoji, limit: 30, offset: 0 }
                    });
                }

                function rxEnsureContainer(msgEl){
                    let cont = msgEl.querySelector('.msg-reactions');
                    if(!cont){
                        cont = document.createElement('div');
                        cont.className = 'msg-reactions';
                        const content = msgEl.querySelector('.dlteams-message-content');
                        if(content){ content.appendChild(cont); } else { msgEl.appendChild(cont); }
                    }
                    return cont;
                }

                function rxRenderChips(container, msgId, aggregates){
                    container.innerHTML = '';
                    const visible = (aggregates || []).filter(a => (a.count > 0));
                    visible.forEach(a=>{
                        const chip = rxBuildChip(msgId, a.emoji_key, a.count, a.reacted_by_me);
                        container.appendChild(chip);
                    });
                    container.style.display = visible.length ? 'flex' : 'none';
                }

                function rxBuildChip(msgId, emoji, count, active){
                    const btn = document.createElement('button');
                    btn.type = 'button';
                    btn.className = 'rx-chip';
                    btn.dataset.msgId = msgId;
                    btn.dataset.emoji = emoji;
                    btn.setAttribute('aria-pressed', active ? 'true' : 'false');
                    btn.innerHTML = `<span class="rx-emoji">${emoji}</span> <span class="rx-count">${count}</span>`;

                    // Tooltip "qui a réagi" au survol
                    let whoTimer = null, whoNode = null, cached = null;
                    btn.addEventListener('mouseenter', ()=>{
                        whoTimer = setTimeout(async ()=>{
                            try{
                                // cache simple key
                                const cacheKey = `rx_who_${msgId}_${emoji}`;
                                if (!cached) cached = window[cacheKey];
                                if (!cached) {
                                    const res = await rxApiWho(parseInt(msgId,10), emoji);
                                    if (res && res.ok) {
                                        cached = res;
                                        window[cacheKey] = res;
                                    }
                                }
                                const rect = btn.getBoundingClientRect();
                                whoNode = document.createElement('div');
                                whoNode.className = 'rx-who';
                                whoNode.innerHTML = buildWhoHtml(cached);
                                document.body.appendChild(whoNode);
                                placeWhoNearChip(whoNode, rect);
                            }catch(e){ /* noop */ }
                        }, 250);
                    });
                    btn.addEventListener('mouseleave', ()=>{
                        if (whoTimer){ clearTimeout(whoTimer); whoTimer = null; }
                        if (whoNode){ whoNode.remove(); whoNode = null; }
                    });

                    // Toggle / remplacement
                    btn.addEventListener('click', (e)=>{
                        e.stopPropagation();
                        const container = btn.closest('.msg-reactions');
                        const msgId     = parseInt(btn.dataset.msgId, 10);
                        const emoji     = btn.dataset.emoji;
                        const wasActive = btn.getAttribute('aria-pressed') === 'true';

                        if (wasActive) {
                            // On retire ma réaction actuelle SANS afficher “0”
                            const cntEl = btn.querySelector('.rx-count');
                            const cur = parseInt(cntEl.textContent || '1', 10);
                            if (cur <= 1) {
                                rxRemoveChipImmediate(btn);
                            } else {
                                cntEl.textContent = String(cur - 1);
                                btn.setAttribute('aria-pressed','false');
                                btn.style.border = '1px solid #e2e7f2';
                                btn.style.background = '#fff';
                            }
                            // Serveur (exclusif=1 pour autoriser le “unset” cohérent) puis refresh sûr
                            $.ajax({
                                url: '/marketplace/dlteams/ajax/reaction.toggle.php',
                                type: 'POST',
                                dataType: 'json',
                                data: { itilfollowups_id: msgId, emoji_key: emoji, exclusive: 1 }
                            }).always(()=> rxRefreshOne(msgId, container));
                            return;
                        }

                        // Cliquer une puce inactive => on veut une réaction EXCLUSIVE
                        rxSetExclusive(msgId, emoji, container);
                    });

                    return btn;
                }
                document.addEventListener('click', function(e){
                    const btn = e.target.closest('.action-emoji');
                    if (!btn) return;
                    const msg = btn.closest('.dlteams-message');
                    if (!msg) return;
                    const id = parseInt(msg.dataset.messageId, 10);
                    if (isNaN(id)) return;
                    // 🟢 ouvre la palette ancrée sur l’icône cliquée
                    openReactionPalette(id, btn);
                });

                function optimisticToggle(chip, willActivate){
                    return new Promise(resolve=>{
                        const cntEl = chip.querySelector('.rx-count');
                        const prev  = parseInt(cntEl.textContent || '0', 10);
                        cntEl.textContent = String(Math.max(0, prev + (willActivate ? +1 : -1)));
                        chip.setAttribute('aria-pressed', willActivate ? 'true' : 'false');
                        resolve();
                    });
                }
                function applyServerTruth(chip, res){
                    if (!res || !res.ok) return;
                    const cntEl = chip.querySelector('.rx-count');
                    cntEl.textContent = String(res.newCount);
                    chip.setAttribute('aria-pressed', res.hasReacted ? 'true' : 'false');
                }
                function removeIfZero(chip){
                    const cont = chip.parentElement;
                    const cnt  = parseInt(chip.querySelector('.rx-count').textContent || '0', 10);
                    const active = chip.getAttribute('aria-pressed') === 'true';
                    if (cnt === 0 && !active) {
                        chip.remove();
                        const left = cont.querySelectorAll('.rx-chip').length;
                        cont.style.display = left ? 'flex' : 'none';
                    }
                }

                // Palette
                function buildPalette(onPick){
                    const pop = document.createElement('div');
                    pop.className = 'rx-palette';
                    RX_ALLOWED.forEach(em=>{
                        const b = document.createElement('button');
                        b.type = 'button';
                        b.className = 'rx-em';
                        b.textContent = em;
                        b.addEventListener('click', ()=> onPick(em, pop));
                        pop.appendChild(b);
                    });


                    return pop;
                }
                function placePaletteNearButton(pop, btn){
                    const r = btn.getBoundingClientRect();
                    const top  = Math.max(8, r.top + (r.height/2) - 18);
                    const left = r.left + r.width + 8;
                    pop.style.top  = `${top}px`;
                    pop.style.left = `${left}px`;
                }
                function buildWhoHtml(apiRes){
                    if(!apiRes || !apiRes.ok || !apiRes.rows || apiRes.rows.length===0){
                        return '<div class=\"rx-who-row\" style=\"color:#6b7280\">' + <?php echo json_encode(__('Aucun participant')); ?> + '</div>';
                    }
                    return apiRes.rows.map(r=>{
                        const ini = (r.initials || '?');
                        const bg  = (r.bg || '#666');
                        const nm  = (r.name || '—');
                        return `<div class=\"rx-who-row\">
                              <div class=\"av\" style=\"background:${bg}\">${ini}</div>
                              <div>${nm}</div>
                            </div>`;
                    }).join('');
                }
                function placeWhoNearChip(node, rect){
                    const top  = Math.max(8, rect.top - node.offsetHeight - 8);
                    const left = Math.min(window.innerWidth - node.offsetWidth - 8, rect.left);
                    node.style.top  = `${top}px`;
                    node.style.left = `${left}px`;
                }

                let currentPalette = null;
                function closePalette(){
                    if(currentPalette){
                        currentPalette.remove();
                        currentPalette = null;
                        document.removeEventListener('click', clickAwayClose, true);
                        window.removeEventListener('resize', closePalette);
                        window.removeEventListener('scroll', closePalette, true);
                    }
                }
                function clickAwayClose(e){
                    if(currentPalette && !currentPalette.contains(e.target)) closePalette();
                }

                window.openReactionPalette = function(msgId, iconEl){
                    // toggle
                    if(currentPalette){
                        const same = currentPalette.dataset.forMsg === String(msgId);
                        closePalette();
                        if(same) return;
                    }
                    const msgEl = document.getElementById('kbcomment'+msgId);
                    if(!msgEl) return;
                    const container = rxEnsureContainer(msgEl);

                    const onPick = (emoji, pop) => {
                        // Remplacement: si j'ai déjà une emoji différente, je la retirerai dans rxBuildChip.onClick
                        const existing = container.querySelector(`.rx-chip[data-emoji=\"${emoji}\"]`);
                        if (existing) {
                            existing.click(); // (same => supprime) ou (active si pas moi)
                        } else {
                            const mine = container.querySelector('.rx-chip[aria-pressed=\"true\"]');
                            // créer un chip pour la nouvelle si absent
                            const c = rxBuildChip(String(msgId), emoji, 0, false);
                            container.appendChild(c);
                            container.style.display = 'flex';
                            // si j'avais une autre réaction, rxBuildChip va gérer remplacement
                            c.click();
                            // si mine existait et tombe à 0, il sera retiré par removeIfZero
                        }
                        closePalette();
                    };

                    const pop = buildPalette(onPick);
                    pop.dataset.forMsg = String(msgId);
                    document.body.appendChild(pop);
                    placePaletteNearButton(pop, iconEl);
                    currentPalette = pop;

                    setTimeout(()=>document.addEventListener('click', clickAwayClose, true), 0);
                    window.addEventListener('resize', closePalette);
                    window.addEventListener('scroll', closePalette, true);
                };

                // ---------- Init ----------
                window.dlteamsInitReactions = function(){
                    const msgs = Array.from(document.querySelectorAll('.dlteams-message[data-message-id]'));
                    if (msgs.length === 0) return;
                    const ids = msgs.map(m => parseInt(m.dataset.messageId, 10)).filter(n=>!isNaN(n));

                    msgs.forEach(m => rxEnsureContainer(m));

                    rxApiList(ids).then(res=>{
                        if (!res.ok) return;
                        const data = res.data || {};
                        msgs.forEach(m=>{
                            const id  = parseInt(m.dataset.messageId,10);
                            const agg = data[id] || [];
                            const cont= rxEnsureContainer(m);
                            rxRenderChips(cont, id, agg);
                        });
                    }).catch(console.error);
                };

                // ---------- DOM ready ----------
                $(document).ready(function(){
                    const chatInputContainer    = document.getElementById('chat-input-container');
                    const newConversationButton = document.getElementById('newConversationButton');
                    const newMailButton         = document.getElementById('newMailButton');
                    const hideInputButton       = document.getElementById('hideInputButton');
                    const mailablecontent       = document.getElementById('mailablecontent');
                    const chatContainer         = document.getElementById('dlteams-chat-container');

                    function showChatInput(){
                        if(chatInputContainer) chatInputContainer.style.display = 'block';
                        if(newConversationButton) newConversationButton.style.display = 'none';
                        if(hideInputButton) hideInputButton.style.display = 'block';
                        if(mailablecontent) mailablecontent.style.display = 'none';
                    }
                    function hideChatContainer(){
                        if(chatContainer) chatContainer.style.display = 'none';
                        if(chatInputContainer) chatInputContainer.style.display = 'none';
                        if(mailablecontent) mailablecontent.style.display = 'block';
                    }
                    function hideChatInput(){
                        if(chatInputContainer) chatInputContainer.style.display = 'none';
                        if(newConversationButton) newConversationButton.style.display = 'block';
                        if(hideInputButton) hideInputButton.style.display = 'none';
                    }

                    if(newConversationButton) newConversationButton.addEventListener('click', showChatInput);
                    if(newMailButton)         newMailButton.addEventListener('click', hideChatContainer);
                    if(hideInputButton)       hideInputButton.addEventListener('click', hideChatInput);

                    // Conversations : état initial + handlers
                    document.querySelectorAll('.dlteams-conversation').forEach(conv=>{
                        applyInitialCollapse(conv);
                        attachConversationHandlers(conv);
                    });

                    // Messages : collapsed + binder
                    document.querySelectorAll('.dlteams-message').forEach(msg=>{
                        applyMsgCollapsedState(msg);
                        const btn = msg.querySelector('.msg-collapse');
                        if(btn){ btn.addEventListener('click', ()=>toggleMsgCollapse(msg)); }
                    });

                    // Badges non lus
                    updateUnreadBadges();

                    // Focus hash si présent
                    let hash = window.location.hash;
                    if(!hash || !hash.startsWith('#kbcomment')){
                        const href = String(window.location.href);
                        const idx  = href.indexOf('#kbcomment');
                        if(idx >= 0){ hash = href.substring(idx); }
                    }
                    if(hash && hash.startsWith('#kbcomment')){
                        const domId = hash.replace('#','').trim();
                        if(document.getElementById(domId)){
                            setTimeout(()=>scrollToMessageDomId(domId), 150);
                        }
                    }

                    // Initialiser réactions
                    if (typeof window.dlteamsInitReactions === 'function') {
                        window.dlteamsInitReactions();
                    }
                });
            })();
        </script>
        <?php
    }




    private static function flattenConversationChrono(array $node, array &$out)
    {
        $out[] = $node;
        if (!empty($node['answers']) && is_array($node['answers'])) {
            usort($node['answers'], function ($a, $b) {
                return strtotime($a['date_creation'] ?? '0000-00-00 00:00:00')
                    <=> strtotime($b['date_creation'] ?? '0000-00-00 00:00:00');
            });
            foreach ($node['answers'] as $child) {
                self::flattenConversationChrono($child, $out);
            }
        }
    }


    /**************************************************
     * FORMULAIRE D’ENVOI (inchangé, cosmétique mineure)
     **************************************************/
    private static function renderMessageForm($items_id, $itemtype)
    {
        ob_start();

        echo "<div class='dlteams-toolbar'>
            <button type='button' class='btn btn-primary btn-sm' id='newConversationButton'>"
            . __('Nouvelle conversation') . "</button>
            <button type='button' class='btn btn-secondary btn-sm' id='hideInputButton' style='display:none;'>"
            . __('Masquer') . "</button>
            <button type='button' class='btn btn-outline-primary btn-sm' id='newMailButton'>"
            . __('Nouveau mail') . "</button>
          </div>";

        echo "<div id='chat-input-container' style='display:none'>";
        echo "<form name='messageform' id='messageform'
                 class='comment_form' method='post'
                 action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
        echo "  <div class='dlteams-chat-footer'>";

        echo '  <div id="reply-content-placeholder" style="display:none; position:relative; justify-content: space-between">
                <blockquote class="reply-quote"></blockquote>
                <span onclick="exitMode()" style="font-weight: bold; cursor: pointer" class="reply-exit">×</span>
            </div>';

        echo "  <div class='input-row'>";
        echo "      <div class='input-col'>";
        echo              Html::textarea([
            "display"         => false,
            "editor_id"       => "dlteamsMessageInput",
            "enable_richtext" => true,
            'cols'            => 1,
            'rows'            => 1,
            'name'            => 'content',
            "value"           => "",
            "placeholder"     => __("Votre message.."),
        ]);
        echo "      </div>";
        echo "      <input type='hidden' name='items_id' value='{$items_id}'>";
        echo "      <input type='hidden' name='itemtype' value='{$itemtype}'>";
        echo "      <button name='add' class='send-btn' title='" . __('Envoyer') . "'><i class='fa fa-paper-plane'></i></button>";
        echo "  </div>";

        echo "  </div>";
        Html::closeForm(true);
        echo "</div>";

        $object = new $itemtype();
        $object->getFromDB($items_id);

        echo "<div id='mailablecontent' style='display:none; margin:1rem'>";
        \Glpi\Application\View\TemplateRenderer::getInstance()->display('@dlteams/components/itilobject/timeline/mailable.html.twig', [
            "processor" => Toolbox::getItemTypeFormURL(__CLASS__),
            "item"      => $object
        ]);
        echo "</div>";

        return ob_get_clean();
    }


    /**************************************************
     * FETCH (ne marque pas 'vu' par défaut)
     **************************************************/
    private static function fetchComments($itemId, $itemType)
    {
        // Ne pas marquer 'vu' ici pour laisser la logique "unread" côté UI
        $comments = self::getCommentsForKbItem($itemId, $itemType, null, false /* isplannif */, false /* child */, false /* mark_view */);

        if ($itemType === PluginDlteamsTicketTask::class) {
            global $DB;
            $query = [
                'FROM'  => TicketTask::getTable(),
                'WHERE' => ['tickettasks_id' => $itemId],
            ];
            foreach ($DB->request($query) as $task) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($task['id'], $itemType, null, true, false, false)
                );
            }
        } elseif ($itemType === Ticket::class) {
            global $DB;

            // Tasks
            $query = [
                'FROM'  => TicketTask::getTable(),
                'WHERE' => ['tickets_id' => $itemId],
            ];
            foreach ($DB->request($query) as $task) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($task['id'], PluginDlteamsTicketTask::class, null, true, false, false)
                );
            }

            // Documents
            $query = [
                'FROM'  => Document_Item::getTable(),
                'WHERE' => ['items_id' => $itemId, 'itemtype' => Ticket::class],
            ];
            foreach ($DB->request($query) as $document) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($document['documents_id'], Document::class, null, true, false, false)
                );
            }

            // Problems
            $query = [
                'FROM'  => Problem_Ticket::getTable(),
                'WHERE' => ['tickets_id' => $itemId],
            ];
            foreach ($DB->request($query) as $pt) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($pt['problems_id'], Problem::class, null, true, false, false)
                );
            }

            // Changes
            $query = [
                'FROM'  => Change_Ticket::getTable(),
                'WHERE' => ['tickets_id' => $itemId],
            ];
            foreach ($DB->request($query) as $ct) {
                $comments = array_merge(
                    $comments,
                    self::getCommentsForKbItem($ct['changes_id'], Change::class, null, true, false, false)
                );
            }

        } elseif ($itemType === User::class) {
            // Vue "globale" utilisateur : toutes racines
            $comments = self::getCommentsForKbItem(["<>", 0], $itemType, null, false, false, false);
        }

        return $comments;
    }



    /**************************************************
     * HELPERS : annoter root_id + flatten chrono
     **************************************************/
    private static function annotateRootId(array &$node, $rootId)
    {
        $node['root_id'] = $rootId;
        if (!empty($node['answers']) && is_array($node['answers'])) {
            foreach ($node['answers'] as &$child) {
                self::annotateRootId($child, $rootId);
            }
            unset($child);
        }
    }


    /**************************************************
     * FLATTEN (garde si besoin ailleurs)
     **************************************************/
    static function flattenComments(array $comments, $parentId = null, &$flatList = [], &$processedIds = [])
    {
        foreach ($comments as $comment) {
            if (in_array($comment['id'], $processedIds)) continue;
            $comment['parent_comment_id'] = $parentId;
            $flatList[] = $comment;
            $processedIds[] = $comment['id'];
            if (!empty($comment['answers'])) {
                self::flattenComments($comment['answers'], $comment['id'], $flatList, $processedIds);
            }
        }
        return $flatList;
    }


    /**************************************************
     * TRI GLOBAL (ASC)
     **************************************************/
    static function sortCommentsByDate(array &$comments)
    {
        usort($comments, function ($a, $b) {
            $da = strtotime($a['date_creation'] ?? '0000-00-00 00:00:00');
            $db = strtotime($b['date_creation'] ?? '0000-00-00 00:00:00');
            return $da <=> $db;
        });
        // Trier récursivement les answers
        foreach ($comments as &$n) {
            if (!empty($n['answers']) && is_array($n['answers'])) {
                self::sortCommentsByDate($n['answers']);
            }
        }
    }


    /**************************************************
     * RÉCUPÉRATION DB (option mark_view)
     **************************************************/
    public static function getCommentsForKbItem(
        $kbitem_id,
        $itemtype,
        $parent = null,
        $isplannif_comment = false,
        $ischildcomment   = false,
        $mark_view        = false // <== par défaut : ne marque pas la vue
    ){
        global $DB;

        $where = [
            'items_id'          => $kbitem_id,
            'itemtype'          => $itemtype,
            'parent_comment_id' => $parent,
            'entities_id'       => Session::getActiveEntity()
        ];

        $db_comments = $DB->request(ITILFollowup::getTable(), $where + ['ORDER' => 'id ASC']);

        $comments = [];
        foreach ($db_comments as $db_comment) {
            // Marquer 'vu' seulement si demandé
            if ($mark_view) {
                $view = new PluginDlteamsITILFollowup_View();
                $criteria = [
                    "itilfollowups_id" => $db_comment["id"],
                    "itemtype"         => User::class,
                    "items_id"         => Session::getLoginUserID()
                ];
                $crit = [
                    'SELECT' => PluginDlteamsITILFollowup_View::getIndexName(),
                    'FROM'   => PluginDlteamsITILFollowup_View::getTable(),
                    'WHERE'  => $criteria
                ];
                $iter = $DB->request($crit);
                if (count($iter) == 0) {
                    $view->add($criteria);
                }
            }

            // Récursif
            $db_comment['answers']           = self::getCommentsForKbItem($kbitem_id, $itemtype, $db_comment['id'], $isplannif_comment, true, $mark_view);
            $db_comment["isplannif_comment"] = $isplannif_comment;
            $db_comment["ischild_comment"]   = $ischildcomment;
            $comments[] = $db_comment;
        }

        return $comments;
    }


    /**************************************************
     * (Anciennes fonctions conservées si utilisées ailleurs)
     **************************************************/
    public static function compare_dates($a, $b)
    {
        $dateA = isset($a["date_creation"]) && $a["date_creation"] ? strtotime($a["date_creation"]) : 0;
        $dateB = isset($b["date_creation"]) && $b["date_creation"] ? strtotime($b["date_creation"]) : 0;
        if ($dateA == $dateB) return 0;
        return ($dateA < $dateB) ? -1 : 1;
    }

    /* showForItem et displayComments laissées intactes si nécessaires
       aux vues « historiques ». La nouvelle UI passe par showForItemV2. */


    /**
     * Get comment form
     *
     * @param integer $kbitem_id Knowbase item ID
     * @param string $lang Related item language
     * @param false|integer $edit Comment id to edit, or false
     * @param false|integer $answer Comment id to answer to, or false
     * @return string
     */
    public static function getCommentForm($items_id, $itemtype, $edit = false, $answer = false)
    {
        $rand = mt_rand();

        $content = '';
        if ($edit !== false) {
            $comment = new ITILFollowup();
            $comment->getFromDB($edit);
            $content = $comment->fields['content'];
        }

        $if = new PluginDlteamsMessage();
        $disabledtext = "";
        $disabled = false;
        if ($if->getFromDBByCrit(["itemtype" => $itemtype, "items_id" => $items_id, "solved_state" => 1])) {
            $disabledtext = "disabled";
            $disabled = true;
        }

        $html = '';
        if (!$disabled)
            $html .= "<form name='messageform$rand' id='messageform$rand'
                      class='comment_form' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";

        $html .= "<table class='tab_cadre_fixe'>";

        $form_title = ($edit === false ? __('New comment') : __('Edit comment'));
        $html .= "<tr class='tab_bg_2'><th colspan='3'>$form_title</th></tr>";

        $html .= "<tr class='tab_bg_1'><td><label for='comment'>" . _n('Message', 'Messages', 1) . "</label>
         &nbsp;<span class='red'>*</span></td><td style='width: 60%'>";
        $cols = 2;
        $rows = 1;
        $html .= Html::textarea([
            "display" => false,
            "id" => "comment",
            "enable_richtext" => true,
            'cols' => $cols,
            'rows' => $rows,
            'name' => 'content',
            "value" => $content]);
        $html .= "</td><td class='center'>";

        $btn_text = _sx('button', 'Add');
        $btn_name = 'add';

        if ($edit !== false) {
            $btn_text = _sx('button', 'Save');
            $btn_name = 'edit';
        }

        $html .= "<input type='submit' name='$btn_name' $disabledtext value='{$btn_text}' style='margin-right: 0.1rem' class='btn btn-primary'>";
        if ($edit !== false || $answer !== false) {
            $html .= "<input type='reset' name='cancel' value='" . __('Cancel') . "' class='btn btn-primary'>";
        }

        $html .= "<input type='hidden' name='items_id' value='$items_id'>";
        $html .= "<input type='hidden' name='itemtype' value='$itemtype'>";
        if ($answer !== false) {
            $html .= "<input type='hidden' name='parent_comment_id' value='{$answer}'/>";
        }
        if ($edit !== false) {
            $html .= "<input type='hidden' name='id' value='{$edit}'/>";
        }

        $html .= "</td></tr>";
        $html .= "</table>";
        if (!$disabled)
            $html .= Html::closeForm(false);
        return $html;
    }

    public function prepareInputForAdd($input)
    {
        if (!isset($input["users_id"])) {
            $input["users_id"] = 0;
            if ($uid = Session::getLoginUserID()) {
                $input["users_id"] = $uid;
            }
        }

        return $input;
    }

    public static function getDefaultSearchRequest()
    {
        $search = [
            'sort' => 6,
            'order' => 'DESC'
        ];
        return $search;
    }

    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("Id"),
            'datatype' => 'specific',
            'massiveaction' => false,
            'objectfield_display_id' => true
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'itemtype',
            'name' => __("Objet"),
            'datatype' => 'specific',
            'massiveaction' => false,
            'autocomplete' => true,
            'objectfield' => true
        ];


        $tab[] = [
            'id' => '3',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("#Id"),
            'datatype' => 'specific',
            'dlteams_specific_itemtype' => true,
            'toview' => true,
            'massiveaction' => true,

        ];


        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Contenu", 'dlteams'),
            'massiveaction' => true,
            'splititems' => true,
            'htmltext' => true,
            'datatype' => 'text',
            'contentfield' => true
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __('Creation date'),
            'datatype' => 'datetime',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '6',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Date"),
            'datatype' => 'datetime',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '7',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id',
            'name' => __('Posté par'),
            'datatype' => 'text',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'parent_comment_id',
            'name' => __('Conversation'),
            'datatype' => 'itemlink',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'tag',
            'name' => __("Tag"),
            'datatype' => 'text',
            'massiveaction' => false
        ];

        return $tab;

    }

    public function getSpecificMassiveActions($checkitem = null)
    {
        global $DB;

        return parent::getSpecificMassiveActions($checkitem);
    }


    /**
     * Tronque le contenu HTML sans casser les balises.
     *
     * @param string $html Contenu HTML à tronquer.
     * @param int $limit Longueur maximale du contenu tronqué.
     *
     * @return string Contenu tronqué.
     */
    static function truncateHtmlContent($html, $limit)
    {
        // Retourner une chaîne vide si le HTML est invalide
        if (empty(trim($html))) {
            return '';
        }

        $dom = new DOMDocument();

        // Charger le HTML tout en gérant les erreurs
        libxml_use_internal_errors(true);
        $dom->loadHTML('<?xml encoding="utf-8" ?>' . $html, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
        libxml_clear_errors();

        $totalLength = 0;
        $truncated = '';

        // Vérifier si le body contient des nœuds
        $body = $dom->getElementsByTagName('body')->item(0);
        if (!$body || !$body->hasChildNodes()) {
            // Si aucun nœud valide, retourner une version textuelle simplifiée
            return mb_substr(strip_tags($html), 0, $limit) . (mb_strlen(strip_tags($html)) > $limit ? '...' : '');
        }

        // Parcourir les nœuds pour tronquer le contenu
        foreach ($body->childNodes as $node) {
            if ($totalLength >= $limit) {
                break;
            }
            $truncated .= truncateHtmlNode($node, $limit - $totalLength, $totalLength);
        }

        return $truncated . ($totalLength > $limit ? '...' : '');
    }

    /**
     * Tronque un nœud HTML récursivement.
     *
     * @param DOMNode $node Nœud à tronquer.
     * @param int $limit Limite de caractères restants.
     * @param int     &$totalLength Référence à la longueur totale comptabilisée.
     *
     * @return string Contenu tronqué du nœud.
     */
    static function truncateHtmlNode($node, $limit, &$totalLength)
    {
        if ($node->nodeType === XML_TEXT_NODE) {
            $remaining = $limit - $totalLength;
            $content = mb_substr($node->textContent, 0, $remaining);
            $totalLength += mb_strlen($content);
            return htmlspecialchars($content, ENT_QUOTES, 'UTF-8');
        } elseif ($node->nodeType === XML_ELEMENT_NODE) {
            $result = '<' . $node->nodeName;

            // Ajouter les attributs de la balise
            foreach ($node->attributes as $attribute) {
                $result .= ' ' . $attribute->nodeName . '="' . htmlspecialchars($attribute->nodeValue, ENT_QUOTES, 'UTF-8') . '"';
            }
            $result .= '>';

            // Traiter les enfants récursivement
            foreach ($node->childNodes as $child) {
                if ($totalLength >= $limit) {
                    break;
                }
                $result .= truncateHtmlNode($child, $limit, $totalLength);
            }

            $result .= '</' . $node->nodeName . '>';
            return $result;
        }
        return '';
    }

    public static function getNonReplyCommentCount(CommonDBTM $item, $withtemplate = 0)
    {
        $itemId = $item->fields['id'];
        $itemType = $item->getType();

        // Récupérer les commentaires
        $comments = self::fetchComments($itemId, $itemType);
        self::sortCommentsByDate($comments);

        $nonReplyCount = 0;

        if (!empty($comments)) {
            foreach ($comments as $comment) {
                // Vérifier si le commentaire principal n'est pas une réponse
                if (!$comment['isReply']) {
                    $nonReplyCount++;
                }

                // Vérifier les réponses associées
                if (!empty($comment['answers'])) {
                    $comment['answers'] = self::flattenComments($comment['answers']);
                    foreach ($comment['answers'] as $reply) {
                        if (!$reply['isReply']) {
                            $nonReplyCount++;
                        }
                    }
                }
            }
        }

        return $nonReplyCount;
    }

    public static function isSolved(PluginDlteamsMessage $item)
    {
        $if = new PluginDlteamsMessage();
        if ($if->getFromDBByCrit(["itemtype" => $item->getType(), "items_id" => $item->fields["id"], "solved_state" => 1]))
            return true;

        return false;
    }

    public function updateDateMod($ID, $no_stat_computation = false, $users_id_lastupdater = 0)
    {

    }

    /**
     * Get an object using some criteria
     *
     * @param array $crit search criteria
     *
     * @return boolean|array
     * @since 9.2
     *
     */
    public function getFromDBByCrit(array $crit)
    {
        /** @var \DBmysql $DB */
        global $DB;

        $crit = ['SELECT' => 'id',
            'FROM' => $this->getTable(),
            'WHERE' => $crit
        ];

        $iter = $DB->request($crit);
        if (count($iter) >= 1) {
            $row = $iter->current();
            return $this->getFromDB($row['id']);
        }
        return false;
    }

    public static function getEnhancedHtml(?string $content, array $params = []): string
    {
        $p = [
            'images_gallery' => false,
            'user_mentions' => true,
            'images_lazy' => true,
            'text_maxsize' => 1000,
        ];
        $p = array_replace($p, $params);

        $content_size = strlen($content ?? '');

        // Sanitize content first (security and to decode HTML entities)
        $content = \Glpi\RichText\RichText::getSafeHtml($content);

        if ($p['user_mentions']) {
            $content = UserMention::refreshUserMentionsHtmlToDisplay($content);
        }

        if ($p['images_lazy']) {
            $content = self::loadImagesLazy($content);
        }

        if ($p['images_gallery']) {
            $content = self::replaceImagesByGallery($content);
        }

        if ($p['text_maxsize'] > 0 && $content_size > $p['text_maxsize']) {
            $content = <<<HTML
<div class="long_text">$content
    <p class='read_more'>
        <span class='read_more_button'>...</span>
    </p>
</div>
HTML;
            $content .= HTML::scriptBlock('$(function() { read_more(); });');
        }

        return $content;
    }

    /**
     * Replace images by gallery component in rich text.
     *
     * @param string $content
     *
     * @return string
     * @since 10.0.0
     *
     */
    private static function replaceImagesByGallery(string $content): string
    {

        $image_matches = [];
        preg_match_all(
            '/<a[^>]*>\s*<img[^>]*src=["\']([^"\']*document\.send\.php\?docid=([0-9]+)(?:&[^"\']+)?)["\'][^>]*>\s*<\/a>/',
            $content,
            $image_matches,
            PREG_SET_ORDER
        );
        foreach ($image_matches as $image_match) {
            $img_tag = $image_match[0];
            $docsrc = $image_match[1];
            $docid = $image_match[2];

            // Special chars are encoded in `src` attribute. We decode them to be sure to work with "raw" data.
            $docsrc = htmlspecialchars_decode($image_match[1], ENT_QUOTES);

            $document = new Document();
            if ($document->getFromDB($docid)) {
                $docpath = GLPI_DOC_DIR . '/' . $document->fields['filepath'];
                if (Document::isImage($docpath)) {
                    //find width / height define by user
                    $width = null;
                    if (preg_match("/width=[\"|'](\d+)(\.\d+)?[\"|']/", $img_tag, $wmatches)) {
                        $width = intval($wmatches[1]);
                    }
                    $height = null;
                    if (preg_match("/height=[\"|'](\d+)(\.\d+)?[\"|']/", $img_tag, $hmatches)) {
                        $height = intval($hmatches[1]);
                    }

                    //find real size from image
                    $imgsize = getimagesize($docpath);

                    $gallery = self::imageGallery([
                        [
                            'src' => $docsrc,
                            'w' => $imgsize[0],
                            'h' => $imgsize[1],
                            'thumbnail_w' => $width,
                            'thumbnail_h' => $height,
                        ]
                    ]);
                    $content = str_replace($img_tag, $gallery, $content);
                }
            }
        }

        return $content;
    }

    /**
     * insert `loading="lazy" into img tag
     *
     * @param string $content
     *
     * @return string
     * @since 10.0.3
     *
     */
    private static function loadImagesLazy(string $content): string
    {
        return preg_replace(
            '/<img([\w\W]+?)\/+>/',
            '<img$1 loading="lazy">',
            $content
        );
    }


}
