<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */
define('periodicity', [
//    null,
    'daily' => __("Journalière", 'dlteams'),
    'weekly' => __("Hebdomadaire", 'dlteams'),
    'monthly' => __("Mensuelle", 'dlteams'),
    'annually' => __("Annuelle", 'dlteams'),
]);

class PluginDlteamsReccurent_Task extends CommonDBTM {

    static $rightname = 'plugin_dlteams_reccurent_task';
    public $dohistory = true;
    protected $usenotepad = true;


    public function prepareInputForAdd($input)
    {
        if(!$input["occurence_nbr"])
            $input["occurence_nbr"] = 0;
        return parent::prepareInputForAdd($input); // TODO: Change the autogenerated stub
    }

    static function canCreate() {return true;}
    static function canView() {return true;}
    static function canUpdate() {return true;}
    static function canDelete() {return true;}
    static function canPurge() {return true;}
    function canCreateItem() {return true;}
    function canViewItem() {return true;}
    function canUpdateItem() {return true;}
    function canDeleteItem() {return true;}
    function canPurgeItem() {return true;}
    function canEdit($id) {return true;}

    static function getTypeName($nb = 0)
    {
        return __("Tâches réccurentes", 'dlteams');
    }

    static function getTypeNameForClass($nb = 0)
    {
        return __("Eléments reliés", 'dlteams');
    }

    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        $nbdoc = $nbitem = 0;
        switch ($item->getType()) {

            default:
                if ($_SESSION['glpishow_count_on_tabs']) {
                    $nbitem = count(self::getRequest($item));
                }
                return static::createTabEntry(static::getTypeName(Session::getPluralNumber()), $nbitem);
        }
    }


    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
            default:
                self::showForitem($item, $withtemplate);
                break;
        }
        return true;
    }

    public  static function getRequest(CommonDBTM $item){
        $params = [
            'SELECT' => [
                'glpi_plugin_dlteams_reccurents_tasks.id AS linkid',
                'glpi_plugin_dlteams_reccurents_tasks.*',
            ],
            'FROM' => 'glpi_plugin_dlteams_reccurents_tasks',
//            'JOIN' => [
//                'glpi_plugin_dlteams_processeddatas' => [
//                    'FKEY' => [
//                        'glpi_plugin_dlteams_processeddatas_items' => 'processeddatas_id',
//                        'glpi_plugin_dlteams_processeddatas' => "id",
//                    ]
//                ],
//            ],
            'WHERE' => [
                'glpi_plugin_dlteams_reccurents_tasks.tickettasks_id' => $item->fields['id'],
            ],
            //'ORDER' => 'glpi_plugin_dlteams_records_items.id',
//			  'ORDER' => 'glpi_plugin_dlteams_processeddatas.plugin_dlteams_processeddatastypes_id',
        ];

        global $DB;
        return $DB->request($params);
    }

    // affichage du formulaire
    static function showForItem(CommonDBTM $item, $withtemplate = 0)
    {
        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = self::getRequest($item);


        $number = count($iterator); // $number est le nombre de ligne à afficher (=nombre de documents reliés)
        $items_list = [];
        $used = [];

        foreach ($iterator as $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }

        if ($canedit) {
            echo "<form name='legalbasi_item_form$rand' id='legalbasi_item_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
//            echo "<input type='hidden' name='records_id' value='" . $item->getID() . "' />";
//            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";

            $title = self::getTypeName();
            $entitled = "Ajouter des catégories de données";
            echo "<table class='tab_cadre_fixe'>";
            echo "<tr class='tab_bg_2'><th colspan='3'>" . $title . "<br><i style='font-weight: normal'>" . "</i></th>";
            echo "<th colspan='1'></th></tr>";
            echo "<th colspan='2'></th></tr>";
//            echo "<tr class='tab_bg_1'><td class='left' width='30%'>" . __($entitled, 'dlteams');
//            echo "</td><td width='20%' class='left'>";
//            Dropdown::show(static::$itemtype_1, [
//                'addicon' => static::$itemtype_1::canCreate(),
//                'name' => 'items_id',
//                'used' => $used
//            ]);
//            echo "</td>";
//            echo "<td width='' colspan='1'>";
//            echo "<span style='display:none' id='td1'>";
//
//            echo "<br/><br/>";
//            echo "<textarea type='text' style='width:100%;float:right;margin-right:5%' maxlength=1000 rows='3' id='update_comment_textarea' name='comment' class='storage_comment1' placeholder='commentaire'></textarea>";
//            echo "</span>";
//            echo "</td>";
//
//            echo "<td width='20%' class='left'><input for='legalbasi_item_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
//            echo "</td></tr>";
            echo "</table>";

            Html::closeForm();
        }


        $iterator = self::getRequest($item);
        if ($iterator) {

            echo "<div class='spaced'>";
//            if ($canedit && $number && $item->getType() != PluginDlteamsConcernedPerson::class) {
//                Html::openMassiveActionsForm('mass' . __class__ . $rand);
//                $massive_action_params = [
//                    'container' => 'mass' . __class__ . $rand,
//                    'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
//                Html::showMassiveActions($massive_action_params);
//            }
            echo "<br/>";

            echo "<table class='tab_cadre_fixehov'>";

            $header_begin = "<tr>";
            $header_top = '';
            $header_bottom = '';
            $header_end = '';

//            if ($canedit && $number && $item->getType() != PluginDlteamsConcernedPerson::class) {
//                $header_begin .= "<th width='10'>";
//                $header_top .= Html::getCheckAllAsCheckbox('mass' . __class__ . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __class__ . $rand);
//                $header_end .= "</th>";
//            }

            $header_end .= "<th>" . __("Durée prévisionnelle") . "</th>";
            $header_end .= "<th>" . __("Périodicité", 'dlteams') . "</th>";
            $header_end .= "<th>" . __("Début") . "</th>";
            $header_end .= "<th>" . __("Fin") . "</th>";
            $header_end .= "<th>" . __("Jours concernés") . "</th>";
            $header_end .= "<th>" . __("Jour du mois concerné") . "</th>";
            $header_end .= "<th>" . __("Nombre d'occurence") . "</th>";
            $header_end .= "</tr>";


            echo $header_begin . $header_top . $header_end;
            foreach ($iterator as $data) {
/*                highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");*/
//                die();
//                if ($data['name']) {
                    echo "<tr class='tab_bg_1'>";

//                    if ($canedit && $number) {
//                        echo "<td width='10'>";
//                        Html::showMassiveActionCheckBox(PluginDlteamsProcessedData_Item::class, $data['linkid']);
//                        echo "</td>";
//                    }


                    echo "<td class='left'>" . CommonITILObject::getActionTime($data["actiontime"]) . "</td>";
                    echo "<td class='left'>" . periodicity[$data["periodicity"]] . "</td>";
                    echo "<td class='left'>" . Html::convDate($data['begin_date']) . "</td>";
                    echo "<td class='left'>" . Html::convDate($data['end_date']) . "</td>";
                    echo "<td class='left'>" . implode(", ", array_map(function ($day) {
                            return ucfirst((new IntlDateFormatter('fr_FR', IntlDateFormatter::FULL, IntlDateFormatter::NONE, null, null, 'EEEE'))
                                ->format(strtotime($day)));
                        }, json_decode($data["day_of_week_json"], true))) . "</td>";

                    $dayofmonth = "--";
                    if($data["day_of_month_json"]){
                        $temp = json_decode($data["day_of_month_json"]);
                        if(count($temp)>0)
                            $dayofmonth = $temp[0];
                    }
                    echo "<td class='left'>" . $dayofmonth . "</td>";

                    $nboccur = "--";
                    if($data["occurence_nbr"] &&  $data["occurence_nbr"] !=0)
                        $nboccur = $data["occurence_nbr"];
                    echo "<td class='left'>" . $nboccur . "</td>";
                    echo "</tr>";
//                }
            }

            if ($iterator->count() > 10) {
                //echo $header_begin . $header_bottom . $header_end;
            }
            echo "</table>";

            if ($canedit && $number > 10) {
                $massive_action_params['ontop'] = false;
                Html::showMassiveActions($massive_action_params);
                Html::closeForm();
            }

            echo "</div>";
        }
    }


}