<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsTicketTask_Validation extends CommonITILValidation
{
    // From CommonDBChild
    public static $itemtype           = 'TicketTask';
    public static $items_id           = 'tickettasks_id';

    public static $rightname                 = 'plugin_dlteams_tickettaskvalidation';

    const CREATEREQUEST               = 1024;
    const CREATEINCIDENT              = 2048;
    const VALIDATEREQUEST             = 4096;
    const VALIDATEINCIDENT            = 8192;

    static function canCreate() {return true;}
    static function canView() {return true;}
    static function canUpdate() {return true;}
    static function canDelete() {return true;}
    static function canPurge() {return true;}
    function canCreateItem() {return true;}
    function canViewItem() {return true;}
    function canUpdateItem() {return true;}
    function canDeleteItem() {return true;}
    function canPurgeItem() {return true;}

    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {


        $nb = 0;
        if ($_SESSION['glpishow_count_on_tabs']) {
            $restrict = [static::$items_id => $item->getID()];
            // No rights for create only count asign ones
            if (!Session::haveRightsOr(static::$rightname, static::getCreateRights())) {
                $restrict['users_id_validate'] = Session::getLoginUserID();
            }
            global $DB;
            $iterator = $DB->Request([
                'FROM'   => $this->getTable(),
                'WHERE'  => [static::$items_id => $item->getField('id')],
                'ORDER'  => 'submission_date DESC'
            ]);

            $nb = count($iterator);
        }
        return self::createTabEntry(self::getTypeName(Session::getPluralNumber()), $nb);

    }

    public function showForm($ID, array $options = [], $tickettasks_id = null)
    {
        if ($ID > 0) {
            $this->canEdit($ID);
        } else {
            $options[static::$items_id] = isset($options['parent']->fields["id"])?$options['parent']->fields["id"]:null;
            $this->check(-1, CREATE, $options);
        }

        $tickettask = new TicketTask();
        $tickettask->getFromDB($tickettasks_id);
        $ttv = new PluginDlteamsTicketTask_Validation();

        $user = new User();
        $user->getFromDB($tickettask->fields["users_id"]);

        echo \Glpi\Application\View\TemplateRenderer::getInstance()->render(
            'components/itilobject/timeline/form_validation.html.twig',
            [
                "item" => $tickettask,
                "subitem" => $ttv,
                "user" => $user->getFromDB($tickettask->fields["users_id"])?$user->fields:[]
            ]
        );

//        TemplateRenderer::getInstance()->display('components/itilobject/timeline/form_validation.html.twig', [
//            'item'      => $options['parent'],
//            'subitem'   => $this,
//            'scroll'    => true,
//        ]);

        return true;
    }

    public function post_updateItem($history = true)
    {

    }

    public function showFormControl($ID, array $options = [], $tickettasks_id = null)
    {
        if ($ID > 0) {
            $this->canEdit($ID);
        } else {
            $options[static::$items_id] = isset($options['parent']->fields["id"])?$options['parent']->fields["id"]:null;
            $this->check(-1, CREATE, $options);
        }

        $tickettask = new TicketTask();
        if($tickettask->getFromDB($tickettasks_id)){
            $user = new User();
            $user->getFromDB($tickettask->fields["users_id"]);
            $user = $user->fields;
        }
        else
            $user = [];

        $ttv = new PluginDlteamsTicketTask_Validation();


//        var_dump("zzz");
//        die();
        echo \Glpi\Application\View\TemplateRenderer::getInstance()->render(
            '@dlteams/components/itilobject/timeline/form_validation.html.twig',
            [
                "item" => $tickettask,
                "subitem" => $ttv,
                "user" => $user
            ]
        );

//        TemplateRenderer::getInstance()->display('components/itilobject/timeline/form_validation.html.twig', [
//            'item'      => $options['parent'],
//            'subitem'   => $this,
//            'scroll'    => true,
//        ]);

        return true;
    }



    /**
     * Get an object using some criteria
     *
     * @since 9.2
     *
     * @param array $crit search criteria
     *
     * @return boolean|array
     */
    public function getFromDBByCrit(array $crit)
    {
        /** @var \DBmysql $DB */
        global $DB;

        $crit = ['SELECT' => 'id',
            'FROM'   => $this->getTable(),
            'WHERE'  => $crit
        ];

        $iter = $DB->request($crit);
        if (count($iter) == 1) {
            $row = $iter->current();
            return $this->getFromDB($row['id']);
        }

        else if (count($iter) > 1) {
//            trigger_error(
//                sprintf(
//                    'getFromDBByCrit expects to get one result, %1$s found in query "%2$s".',
//                    count($iter),
//                    $iter->getSql()
//                ),
//                E_USER_WARNING
//            );

            $row = $iter->current();
            return $this->getFromDB($row['id']);
        }
        return false;
    }


    public static function getTypeName($nb = 0)
    {
        return _n('Evaluation', 'Evaluations', $nb);
    }

    public static function getCreateRights()
    {
        return [static::CREATEREQUEST, static::CREATEINCIDENT];
    }


    public static function getValidateRights()
    {
        return [static::VALIDATEREQUEST, static::VALIDATEINCIDENT];
    }

    /**
     * @param $field
     * @param $values
     * @param $options   array
     **/
    public static function getSpecificValueToDisplay($field, $values, array $options = [])
    {


        if (!is_array($values)) {
            $values = [$field => $values];
        }
        switch ($field) {
            case 'status':
//                $tickettasks_id = $options["raw_data"]["raw"]["id"];
//                global $DB;
//                $iterator = $DB->Request([
//                    'FROM'   => static::getTable(),
//                    'WHERE'  => [static::$items_id => $tickettasks_id],
//                    'ORDER'  => 'submission_date DESC'
//                ]);
//                $iterator_array = iterator_to_array($iterator);
//
//                if(count($iterator_array)>0)
//                    return self::getStatus($iterator_array[array_key_first($iterator_array)]["status"], true);
//                else
//                    return "";
//
/*                    highlight_string("<?php\n\$data =\n" . var_export($iterator_array, true) . ";\n?>");*/
                return self::getStatus($values[$field], true);
        }
        return parent::getSpecificValueToDisplay($field, $values, $options);
    }

    public function prepareInputForAdd($input)
    {

        $input["users_id"] = 0;
        // Only set requester on manual action
        if (
            !isset($input['_auto_import'])
            && !isset($input['_auto_update'])
            && !Session::isCron()
        ) {
            $input["users_id"] = Session::getLoginUserID();
        }

        $input["submission_date"] = $_SESSION["glpi_currenttime"];
        $input["status"]          = self::WAITING;

        if (!isset($input["users_id_validate"]) || ($input["users_id_validate"] <= 0)) {
            return false;
        }

//        $itemtype = static::$itemtype;
//        $input['timeline_position'] = $itemtype::getTimelinePosition($input[static::$items_id], $this->getType(), $input["users_id"]);

        return parent::prepareInputForAdd($input);
    }


    /**
     * Print the validation form
     *
     * @param $ID        integer  ID of the item
     * @param $options   array    options used
     **/
//    public function showForm($ID, array $options = [])
//    {
//        if ($ID > 0) {
//            $this->canEdit($ID);
//        } else {
////            $options[static::$items_id] = $options['parent']->fields["id"];
////            $this->check(-1, CREATE, $options);
//        }
//
//
    /*        highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//        die();
//        \Glpi\Application\View\TemplateRenderer::getInstance()->display('@dlteams/components/itilobject/timeline/form_validation.html.twig', [
//            'item'      => $options['parent'],
//            'subitem'   => $this,
//            'scroll'    => true,
//            'params'    => $_POST
//        ]);
//
//        return true;
//    }

//    /**
//     * @since 0.85
//     **/
//    public function canCreateItem()
//    {
//
//        if ($this->canChildItem('canViewItem', 'canView')) {
//            $ticket = new Ticket();
//            if ($ticket->getFromDB($this->fields['tickets_id'])) {
//                // No validation for closed tickets
//                if (in_array($ticket->fields['status'], $ticket->getClosedStatusArray())) {
//                    return false;
//                }
//
//                if ($ticket->fields['type'] == Ticket::INCIDENT_TYPE) {
//                    return Session::haveRight(self::$rightname, self::CREATEINCIDENT);
//                }
//                if ($ticket->fields['type'] == Ticket::DEMAND_TYPE) {
//                    return Session::haveRight(self::$rightname, self::CREATEREQUEST);
//                }
//            }
//        }
//
//        return parent::canCreateItem();
//    }

    /**
     * @since 0.85
     *
     * @see commonDBTM::getRights()
     **/
    public function getRights($interface = 'central')
    {

        $values = parent::getRights();
        unset($values[UPDATE], $values[CREATE], $values[READ]);

        $values[self::CREATEREQUEST]
            = ['short' => __('Create for request'),
            'long'  => __('Create a validation request for a request')
        ];
        $values[self::CREATEINCIDENT]
            = ['short' => __('Create for incident'),
            'long'  => __('Create a validation request for an incident')
        ];
        $values[self::VALIDATEREQUEST]
            = __('Validate a request');
        $values[self::VALIDATEINCIDENT]
            = __('Validate an incident');

        if ($interface == 'helpdesk') {
            unset($values[PURGE]);
        }

        return $values;
    }

    /**
     * Get Ticket validation status Name
     *
     * @param integer   $value
     * @param bool      $decorated
     **/
    public static function getStatus($value, bool $decorated = false)
    {
        $statuses = self::getAllStatusArray(true, true);

        $label = $statuses[$value] ?? $value;

        if ($decorated) {
            $color   = self::getStatusColor($value);
            $classes = null;
            switch ($value) {
                case self::WAITING:
                    $classes = 'waiting far fa-clock';
                    break;
                case self::ACCEPTED:
                    $classes = 'accepted fas fa-check';
                    break;
                case self::REFUSED:
                    $classes = 'refused fas fa-times';
                    break;
            }

            return sprintf('<span><i class="validationstatus %s"></i> %s</span>', $classes, $label);
        }

        return $label;
    }


    /**
     * Print the validation list into item
     *
     * @param CommonDBTM $item
     **/
    public function showSummary(CommonDBTM $item)
    {
        /**
         * @var array $CFG_GLPI
         * @var \DBmysql $DB
         */
        global $CFG_GLPI, $DB;

//        if (
//        !Session::haveRightsOr(
//            static::$rightname,
//            array_merge(
//                static::getCreateRights(),
//                static::getValidateRights(),
//                static::getPurgeRights()
//            )
//        )
//        ) {
//            return false;
//        }

        $tID    = $item->fields['id'];

        $tmp    = [static::$items_id => $tID];
        $canadd = $this->can(-1, CREATE, $tmp);
        $canadd = true;
        $rand   = mt_rand();

        if ($canadd) {
            $itemtype = static::$itemtype;
            echo "<form method='post' name=form action='" . PluginDlteamsTicketTask::getFormURL() . "'>";
        }
        echo "<table class='tab_cadre_fixe'>";
//        echo "<tr>";
//        echo "<th colspan='3'>" . self::getTypeName(Session::getPluralNumber()) . "</th>";
//        echo "</tr>";

//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __('Global approval status') . "</td>";
//        echo "<td colspan='2'>";
//        echo static::getStatus($item->fields["global_validation"], true);
////        echo "zzz";
//
//        echo "</td></tr>";

//        echo "<tr>";
//        echo "<th colspan='2'>" . _x('item', 'State') . "</th>";
//        echo "<th colspan='2'>";
//        echo self::getValidationStats($tID);
//        echo "</th>";
//        echo "</tr>";

//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __('Minimum validation required') . "</td>";
//        if ($canadd) {
//            echo "<td>";
//            echo $item->getValueToSelect(
//                'validation_percent',
//                'validation_percent',
//                $item->fields["validation_percent"]
//            );
//            echo "</td>";
//            echo "<td><input type='submit' name='update' class='btn btn-outline-secondary' value='" .
//                _sx('button', 'Save') . "'>";
//            if (!empty($tID)) {
//                echo "<input type='hidden' name='id' value='$tID'>";
//            }
//            echo "</td>";
//        } else {
//            echo "<td colspan='2'>";
//            echo Dropdown::getValueWithUnit($item->fields["validation_percent"], "%");
//            echo "</td>";
//        }
//        echo "</tr>";
        echo "</table>";
        if ($canadd) {
            Html::closeForm();
        }

        $iterator = $DB->Request([
            'FROM'   => $this->getTable(),
            'WHERE'  => [static::$items_id => $item->getField('id')],
            'ORDER'  => 'submission_date DESC'
        ]);


        $colonnes = ['', _x('item', 'State'), __('Date demande'), __('Requester'),
//            __('Comments'),
//            __('Date'),
//            __('Approver'),
            __('Approval comments'),
//            __('Documents')
        ];
        $nb_colonnes = count($colonnes);

        $item->showFormHeader([]);
        echo "</td>";
        echo "</tr>";
        echo "</table>";
        echo "<input type='hidden' name='id' value='".$item->fields["id"]."'>";
        echo "<div style='width: 100%; justify-content: start'><button name='task_review' class='btn btn-outline-secondary text-truncate' type='submit'>" .
            _x('button', 'Ajouter une évaluation') . "</button></div>";

        Html::closeForm();

        echo "<table class='tab_cadre_fixehov'>";
        echo "<tr class='noHover'><th colspan='" . $nb_colonnes . "'>" . __('Suivi des évaluations') .
            "</th></tr>";

        if (count($iterator)) {
            $header = "<tr>";
            foreach ($colonnes as $colonne) {
                $header .= "<th>" . $colonne . "</th>";
            }
            $header .= "</tr>";
            echo $header;

            Session::initNavigateListItems(
                $this->getType(),
                //TRANS : %1$s is the itemtype name, %2$s is the name of the item (used for headings of a list)
                sprintf(
                    __('%1$s = %2$s'),
                    $item->getTypeName(1),
                    $item->fields["content"]
                )
            );

            foreach ($iterator as $row) {
                $canedit = $this->canEdit($row["id"]);
                Session::addToNavigateListItems($this->getType(), $row["id"]);
                $bgcolor = self::getStatusColor($row['status']);
                $status  = self::getStatus($row['status']);

                echo "<tr class='tab_bg_1'>";

                echo "<td>";
//                edit icon
//                if($row["comment_validation"]){
                    $id = $row['id'];
                    echo "<span style='border: none; background-color: transparent; cursor: pointer; margin-left: 10px' class='btn-updatecontrole' data-row-id='$id'>";
                    echo "<i class='fas fa-edit me-2'></i>";
                    echo "</span>";
//                }
                echo "</td>";

                echo "<td><div style='background-color:" . $bgcolor . ";'>" . $status . "</div></td>";
                echo "<td>" . Html::convDateTime($row["submission_date"]) . "</td>";
                echo "<td>" . getUserName($row["users_id"]) . "</td>";
                $comment_submission = \Glpi\RichText\RichText::getEnhancedHtml($this->fields['comment_submission'], ['images_gallery' => true]);
//                echo "<td><div class='rich_text_container'>" . $comment_submission . "</div></td>";
//                echo "<td>" . Html::convDateTime($row["validation_date"]) . "</td>";
//                echo "<td>" . getUserName($row["users_id_validate"]) . "</td>";
                $comment_validation = \Glpi\RichText\RichText::getEnhancedHtml($this->fields['comment_validation'] ?? '', ['images_gallery' => true]);
                echo "<td><div class='rich_text_container'>" . $comment_validation??"--" . "</div></td>";

                $doc_item = new Document_Item();
                $docs = $doc_item->find(["itemtype"          => $this->getType(),
                    "items_id"           => $this->getID(),
                    "timeline_position"  => ['>', CommonITILObject::NO_TIMELINE]
                ]);
                $out = "";
                foreach ($docs as $docs_values) {
                    $doc = new Document();
                    $doc->getFromDB($docs_values['documents_id']);
                    $out  .= "<a ";
                    $out .= "href=\"" . Document::getFormURLWithID($docs_values['documents_id']) . "\">";
                    $out .= $doc->getField('name') . "</a><br>";
                }
//                echo "<td>" . $out . "</td>";

                echo "</tr>";
            }
//            echo $header;
        } else {
            //echo "<div class='center b'>".__('No item found')."</div>";
            echo "<tr class='tab_bg_1 noHover'><th colspan='" . $nb_colonnes . "'>";
            echo __('No item found') . "</th></tr>\n";
        }
        echo "</table>";

        $script = "<script>
		$(document).ready(function () {
        $('.btn-updatecontrole').on('click', function () {
            var link_id = $(this).attr('data-row-id');

            glpi_ajax_dialog({
                dialogclass: 'modal-md',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/task_control.form.php',
                params: {
                    items_id: '" . $item->fields["id"] . "',";

        $script .= "linkid: link_id,
                },
                title: 'Contrôle de la tâche " . $this->fields["id"] . "',
                close: function () {

                },
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });});});</script>";

        echo $script;

        echo "<div id='viewvalidation" . $tID . "$rand'></div>\n";

        if ($canadd) {
            echo "<script type='text/javascript' >\n";
            echo "function viewAddValidation" . $tID . "$rand() {\n";
            $params = ['type'             => $this->getType(),
                'parenttype'       => static::$itemtype,
                static::$items_id  => $tID,
                'id'               => -1
            ];
            Ajax::updateItemJsCode(
                "viewvalidation" . $tID . "$rand",
                $CFG_GLPI["root_doc"] . "/marketplace/dlteams/ajax/viewsubitem.php",
                $params
            );
            echo "};";
            echo "</script>";
        }
    }

    public function rawSearchOptions()
    {
        $tab = [];

        $tab[] = [
            'id'                 => 'common',
            'name'               => CommonITILValidation::getTypeName(1)
        ];

        $tab[] = [
            'id'                 => '1',
            'table'              => $this->getTable(),
            'field'              => 'comment_submission',
            'name'               => __('Request comments'),
            'datatype'           => 'text',
            'htmltext'           => true
        ];

        $tab[] = [
            'id'                 => '2',
            'table'              => $this->getTable(),
            'field'              => 'comment_validation',
            'name'               => __('Approval comments'),
            'datatype'           => 'text',
            'htmltext'           => true
        ];

        $tab[] = [
            'id'                 => '3',
            'table'              => $this->getTable(),
            'field'              => 'status',
            'name'               => __('Status'),
            'searchtype'         => 'equals',
            'datatype'           => 'specific'
        ];

        $tab[] = [
            'id'                 => '4',
            'table'              => $this->getTable(),
            'field'              => 'submission_date',
            'name'               => __('Request date'),
            'datatype'           => 'datetime'
        ];

        $tab[] = [
            'id'                 => '5',
            'table'              => $this->getTable(),
            'field'              => 'validation_date',
            'name'               => __('Approval date'),
            'datatype'           => 'datetime'
        ];

        $tab[] = [
            'id'                 => '6',
            'table'              => 'glpi_users',
            'field'              => 'name',
            'name'               => __('Approval requester'),
            'datatype'           => 'itemlink',
            'right'              => [
                'create_incident_validation',
                'create_request_validation'
            ]
        ];

        $tab[] = [
            'id'                 => '7',
            'table'              => 'glpi_users',
            'field'              => 'name',
            'linkfield'          => 'users_id_validate',
            'name'               => __('Approver'),
            'datatype'           => 'itemlink',
            'right'              => [
                'validate_request',
                'validate_incident'
            ]
        ];

        return $tab;
    }


    public static function rawSearchOptionsToAdd()
    {
        $tab = [];

        $tab[] = [
            'id'                 => 'validation',
            'name'               => CommonITILValidation::getTypeName(1)
        ];

        $tab[] = [
            'id'                 => '51',
            'table'              => getTableForItemType(static::$itemtype),
            'field'              => 'validation_percent',
            'name'               => __('Minimum validation required'),
            'datatype'           => 'number',
            'unit'               => '%',
            'min'                => 0,
            'max'                => 100,
            'step'               => 50
        ];

        $tab[] = [
            'id'                 => '52',
            'table'              => getTableForItemType(static::$itemtype),
            'field'              => 'global_validation',
            'name'               => CommonITILValidation::getTypeName(1),
            'searchtype'         => 'equals',
            'datatype'           => 'specific'
        ];

        $tab[] = [
            'id'                 => '53',
            'table'              => static::getTable(),
            'field'              => 'comment_submission',
            'name'               => __('Request comments'),
            'datatype'           => 'text',
            'htmltext'           => true,
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'jointype'           => 'child'
            ]
        ];

        $tab[] = [
            'id'                 => '54',
            'table'              => static::getTable(),
            'field'              => 'comment_validation',
            'name'               => __('Approval comments'),
            'datatype'           => 'text',
            'htmltext'           => true,
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'jointype'           => 'child'
            ]
        ];

        $tab[] = [
            'id'                 => '55',
            'table'              => static::getTable(),
            'field'              => 'status',
            'datatype'           => 'specific',
            'name'               => __('Approval status'),
            'searchtype'         => 'equals',
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'jointype'           => 'child'
            ]
        ];

        $tab[] = [
            'id'                 => '56',
            'table'              => static::getTable(),
            'field'              => 'submission_date',
            'name'               => __('Request date'),
            'datatype'           => 'datetime',
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'jointype'           => 'child'
            ]
        ];

        $tab[] = [
            'id'                 => '57',
            'table'              => static::getTable(),
            'field'              => 'validation_date',
            'name'               => __('Approval date'),
            'datatype'           => 'datetime',
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'jointype'           => 'child'
            ]
        ];

        $tab[] = [
            'id'                 => '58',
            'table'              => 'glpi_users',
            'field'              => 'name',
            'name'               => _n('Requester', 'Requesters', 1),
            'datatype'           => 'itemlink',
            'right'              => (static::$itemtype == 'Ticket' ? 'create_ticket_validate' : 'create_validate'),
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'beforejoin'         => [
                    'table'              => static::getTable(),
                    'joinparams'         => [
                        'jointype'           => 'child'
                    ]
                ]
            ]
        ];

        $tab[] = [
            'id'                 => '59',
            'table'              => 'glpi_users',
            'field'              => 'name',
            'linkfield'          => 'users_id_validate',
            'name'               => __('Approver'),
            'datatype'           => 'itemlink',
            'right'              => (static::$itemtype == 'Ticket' ?
                ['validate_request', 'validate_incident'] :
                'validate'
            ),
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'beforejoin'         => [
                    'table'              => static::getTable(),
                    'joinparams'         => [
                        'jointype'           => 'child'
                    ]
                ]
            ]
        ];

        return $tab;
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        $validation = new static();
        $validation->showSummary($item);
        return true;
    }

}