<?php
/**
-------------------------------------------------------------------------
LICENSE

This file is part of Reports plugin for GLPI.

Reports is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Reports is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Reports. If not, see <http://www.gnu.org/licenses/>.

@package   reports
@authors    Nelly Mahu-Lasson, Remi Collet
@copyright Copyright (c) 2009-2022 Reports plugin team
@license   AGPL License 3.0 or (at your option) any later version
http://www.gnu.org/licenses/agpl-3.0-standalone.html
@link      https://forge.glpi-project.org/projects/reports
@link      http://www.glpi-project.org/
@since     2009
--------------------------------------------------------------------------
 */

$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0; // not really a big SQL request

include ("../../../../inc/includes.php");

$dbu = new DbUtils();

//if(isset($_POST["publish_dlteams"])){
//
//}
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
//TRANS: The name of the report = Location tree
$report = new PluginReportsAutoReport(__('Rapport des responsables de traitements', 'dlteams'));

//Display criterias form is needed
$report->displayCriteriasForm();

$report->setColumns([
    new PluginReportsColumn('full_name', __('Nom complet'), ['sorton' => 'full_name']),
    new PluginReportsColumn('registration_number', __('Service'), ['sorton' => 'registration_number']),
    new PluginReportsColumn('completenumber', __('Num'), ['sorton' => 'completenumber']),
    new PluginReportsColumn('name', __('Traitement'), ['sorton' => 'name']),
//    new PluginReportsColumn('entity', __('Entité'), ['sorton' => 'entity']),
]);


// SQL statement
$query = "SELECT CONCAT(t2.`firstname`, ' ', t2.`realname`) AS full_name, 
       t2.`registration_number`, 
       t1.`completenumber`, 
       t1.`name`,
       `glpi_entities`.`name` AS entity
FROM `glpi_plugin_dlteams_records` AS t1
LEFT JOIN `glpi_users` AS t2
ON t2.`id` = t1.`users_id_tech`
LEFT JOIN `glpi_entities` ON (`t1`.`entities_id` = `glpi_entities`.`id`)
WHERE t1.`is_deleted` = 0" .
    $dbu->getEntitiesRestrictRequest(" AND ", "t1") .
    $report->getOrderBy('completenumber');

$report->setGroupBy(['registration_number', 'full_name'] );
//$report->setGroupBy('registration_number');
//$report->setGroupBy('completenumber');
$report->setSqlRequest($query);
$report->execute();